/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectListFilter;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeComparator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectList
extends Composite {
    public static final int NONE = 0;
    public static final int CHECKBOXES = 1;
    private ObjectListFilter filter;
    private boolean filterEnabled = true;
    private TableViewer objectList;
    private Composite filterArea;
    private Label filterLabel;
    private Text filterText;
    private NXCListener sessionListener = null;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private int changeCount = 0;

    public ObjectList(Composite parent, int style, int options) {
        super(parent, style);
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.objectList = new TableViewer((Composite)this, 0x10004 | ((options & 1) == 1 ? 32 : 0));
        this.objectList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.objectList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.objectList.setComparator((ViewerComparator)new ObjectTreeComparator());
        this.filter = new ObjectListFilter();
        this.objectList.addFilter((ViewerFilter)this.filter);
        this.objectList.setInput((Object)this.session.getAllObjects());
        this.filterArea = new Composite((Composite)this, 0);
        this.filterLabel = new Label(this.filterArea, 0);
        this.filterLabel.setText(Messages.ObjectList_Filter);
        this.filterText = new Text(this.filterArea, 2048);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectList.this.filter.setFilterString(ObjectList.this.filterText.getText());
                ObjectList.this.objectList.refresh(false);
            }
        });
        this.filterArea.setLayout((Layout)new GridLayout(2, false));
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterArea);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectList.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterArea.setLayoutData((Object)fd);
        this.sessionListener = new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 4 || n.getCode() == 99) {
                    ObjectList objectList = ObjectList.this;
                    objectList.changeCount = objectList.changeCount + 1;
                    new UIJob(ObjectList.this.getDisplay(), Messages.ObjectList_JobTitle){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (ObjectList.this.isDisposed() || ObjectList.this.objectList.getControl().isDisposed()) {
                                return Status.OK_STATUS;
                            }
                            ObjectList objectList = ObjectList.this;
                            objectList.changeCount = objectList.changeCount - 1;
                            if (ObjectList.this.changeCount <= 0) {
                                ObjectList.this.objectList.setInput((Object)ObjectList.this.session.getAllObjects());
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule(500L);
                }
            }
        };
        this.session.addListener((SessionListener)this.sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ObjectList.this.session != null && ObjectList.this.sessionListener != null) {
                    ObjectList.this.session.removeListener((SessionListener)ObjectList.this.sessionListener);
                }
            }
        });
        this.filterText.setFocus();
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterArea.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.objectList.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterArea) : new FormAttachment(0, 0);
        this.layout();
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
    }

    public String getFilter() {
        return this.filterText.getText();
    }

    public Control getTableControl() {
        return this.objectList.getControl();
    }

    public TableViewer getTableViewer() {
        return this.objectList;
    }
}

