/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.base.GeoLocation;
import org.netxms.base.GeoLocationFormatException;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImageSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class MapBackground
extends PropertyPage {
    private NetworkMap object;
    private Button radioTypeNone;
    private Button radioTypeImage;
    private Button radioTypeGeoMap;
    private ImageSelector image;
    private LabeledText latitude;
    private LabeledText longitude;
    private Scale zoomScale;
    private Spinner zoomSpinner;
    private Label zoomLabel;
    private ColorSelector backgroundColor;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (NetworkMap)this.getElement().getAdapter(NetworkMap.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        dialogArea.setLayout((Layout)layout);
        Group typeGroup = new Group(dialogArea, 0);
        typeGroup.setText("Background type");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        typeGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        typeGroup.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapBackground.this.enableControls(MapBackground.this.radioTypeImage.getSelection(), MapBackground.this.radioTypeGeoMap.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioTypeNone = new Button((Composite)typeGroup, 16);
        this.radioTypeNone.setText("&None");
        this.radioTypeNone.setSelection(this.object.getBackground().equals(NXCommon.EMPTY_GUID));
        this.radioTypeNone.addSelectionListener(listener);
        this.radioTypeImage = new Button((Composite)typeGroup, 16);
        this.radioTypeImage.setText("&Image");
        this.radioTypeImage.setSelection(!this.object.getBackground().equals(NXCommon.EMPTY_GUID) && !this.object.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND));
        this.radioTypeImage.addSelectionListener(listener);
        this.radioTypeGeoMap = new Button((Composite)typeGroup, 16);
        this.radioTypeGeoMap.setText("&Geographic Map");
        this.radioTypeGeoMap.setSelection(this.object.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND));
        this.radioTypeGeoMap.addSelectionListener(listener);
        this.image = new ImageSelector(dialogArea, 0);
        this.image.setLabel("Background image");
        if (this.radioTypeImage.getSelection()) {
            this.image.setImageGuid(this.object.getBackground(), true);
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.image.setLayoutData((Object)gd);
        Group geomapGroup = new Group(dialogArea, 0);
        geomapGroup.setText("Geographic map");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        geomapGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        geomapGroup.setLayout((Layout)layout);
        GeoLocation gl = this.object.getBackgroundLocation();
        this.latitude = new LabeledText((Composite)geomapGroup, 0);
        this.latitude.setLabel("Latitude");
        this.latitude.setText(gl.getLatitudeAsString());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.latitude.setLayoutData((Object)gd);
        this.longitude = new LabeledText((Composite)geomapGroup, 0);
        this.longitude.setLabel("Longitude");
        this.longitude.setText(gl.getLongitudeAsString());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.longitude.setLayoutData((Object)gd);
        Composite zoomGroup = new Composite((Composite)geomapGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        zoomGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        zoomGroup.setLayoutData((Object)gd);
        this.zoomLabel = new Label(zoomGroup, 0);
        this.zoomLabel.setText("Zoom level");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        this.zoomLabel.setLayoutData((Object)gd);
        this.zoomScale = new Scale(zoomGroup, 256);
        this.zoomScale.setMinimum(1);
        this.zoomScale.setMaximum(18);
        this.zoomScale.setSelection(this.object.getBackgroundZoom());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.zoomScale.setLayoutData((Object)gd);
        this.zoomScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapBackground.this.zoomSpinner.setSelection(MapBackground.this.zoomScale.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.zoomSpinner = new Spinner(zoomGroup, 2048);
        this.zoomSpinner.setMinimum(1);
        this.zoomSpinner.setMaximum(18);
        this.zoomSpinner.setSelection(this.object.getBackgroundZoom());
        this.zoomSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapBackground.this.zoomScale.setSelection(MapBackground.this.zoomSpinner.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite colorArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        colorArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        colorArea.setLayoutData((Object)gd);
        Label label = new Label(colorArea, 0);
        label.setText("Background color:");
        this.backgroundColor = new ColorSelector(colorArea);
        this.backgroundColor.setColorValue(ColorConverter.rgbFromInt((int)this.object.getBackgroundColor()));
        this.enableControls(this.radioTypeImage.getSelection(), this.radioTypeGeoMap.getSelection());
        return dialogArea;
    }

    private void enableControls(boolean imageGroup, boolean geoGroup) {
        this.image.setEnabled(imageGroup);
        this.latitude.setEnabled(geoGroup);
        this.longitude.setEnabled(geoGroup);
        this.zoomLabel.setEnabled(geoGroup);
        this.zoomScale.setEnabled(geoGroup);
        this.zoomSpinner.setEnabled(geoGroup);
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        if (this.radioTypeNone.getSelection()) {
            md.setMapBackground(NXCommon.EMPTY_GUID, new GeoLocation(false), 0, ColorConverter.rgbToInt((RGB)this.backgroundColor.getColorValue()));
        } else if (this.radioTypeImage.getSelection()) {
            md.setMapBackground(this.image.getImageGuid(), new GeoLocation(false), 0, ColorConverter.rgbToInt((RGB)this.backgroundColor.getColorValue()));
        } else if (this.radioTypeGeoMap.getSelection()) {
            GeoLocation location;
            try {
                location = GeoLocation.parseGeoLocation((String)this.latitude.getText(), (String)this.longitude.getText());
            }
            catch (GeoLocationFormatException geoLocationFormatException) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Geolocation format error");
                return false;
            }
            md.setMapBackground(NetworkMap.GEOMAP_BACKGROUND, location, this.zoomSpinner.getSelection(), ColorConverter.rgbToInt((RGB)this.backgroundColor.getColorValue()));
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update map background for map object " + this.object.getObjectName(), null, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return "Cannot modify background for map object " + MapBackground.this.object.getObjectName();
            }

            protected void jobFinalize() {
                if (isApply) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MapBackground.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

