/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkEditor;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class MapLinkGeneral
extends PropertyPage {
    private LinkEditor object;
    private LabeledText name;
    private LabeledText connector1;
    private LabeledText connector2;
    private Button radioColorDefault;
    private Button radioColorObject;
    private Button radioColorCustom;
    private ColorSelector color;
    private ObjectSelector statusObject;
    private Combo routingAlgorithm;

    protected Control createContents(Composite parent) {
        this.object = (LinkEditor)this.getElement().getAdapter(LinkEditor.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.object.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.connector1 = new LabeledText(dialogArea, 0);
        this.connector1.setLabel("Name for connector 1");
        this.connector1.setText(this.object.getConnectorName1());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.connector1.setLayoutData((Object)gd);
        this.connector2 = new LabeledText(dialogArea, 0);
        this.connector2.setLabel("Name for connector 2");
        this.connector2.setText(this.object.getConnectorName2());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.connector2.setLayoutData((Object)gd);
        Group colorGroup = new Group(dialogArea, 0);
        colorGroup.setText("Color");
        layout = new GridLayout();
        colorGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        colorGroup.setLayoutData((Object)gd);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapLinkGeneral.this.color.setEnabled(MapLinkGeneral.this.radioColorCustom.getSelection());
                MapLinkGeneral.this.statusObject.setEnabled(MapLinkGeneral.this.radioColorObject.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioColorDefault = new Button((Composite)colorGroup, 16);
        this.radioColorDefault.setText("&Default color");
        this.radioColorDefault.setSelection(this.object.getColor() < 0 && this.object.getStatusObject() == 0L);
        this.radioColorDefault.addSelectionListener(listener);
        this.radioColorObject = new Button((Composite)colorGroup, 16);
        this.radioColorObject.setText("Based on object &status");
        this.radioColorObject.setSelection(this.object.getStatusObject() != 0L);
        this.radioColorObject.addSelectionListener(listener);
        this.statusObject = new ObjectSelector((Composite)colorGroup, 0, true);
        this.statusObject.setLabel("Status object");
        this.statusObject.setObjectClass(GenericObject.class);
        this.statusObject.setObjectId(this.object.getStatusObject());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.statusObject.setLayoutData((Object)gd);
        this.statusObject.setEnabled(this.radioColorObject.getSelection());
        this.radioColorCustom = new Button((Composite)colorGroup, 16);
        this.radioColorCustom.setText("&Custom color");
        this.radioColorCustom.setSelection(this.object.getColor() >= 0 && this.object.getStatusObject() == 0L);
        this.radioColorCustom.addSelectionListener(listener);
        this.color = new ColorSelector((Composite)colorGroup);
        if (this.radioColorCustom.getSelection()) {
            this.color.setColorValue(ColorConverter.rgbFromInt((int)this.object.getColor()));
        } else {
            this.color.setEnabled(false);
        }
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.color.getButton().setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.routingAlgorithm = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Routing algorithm", (Object)gd);
        this.routingAlgorithm.add("Map Default");
        this.routingAlgorithm.add("Direct");
        this.routingAlgorithm.add("Manhattan");
        this.routingAlgorithm.add("Bend points");
        this.routingAlgorithm.select(this.object.getRoutingAlgorithm());
        return dialogArea;
    }

    private boolean applyChanges(boolean isApply) {
        this.object.setName(this.name.getText());
        this.object.setConnectorName1(this.connector1.getText());
        this.object.setConnectorName2(this.connector2.getText());
        if (this.radioColorCustom.getSelection()) {
            this.object.setColor(ColorConverter.rgbToInt((RGB)this.color.getColorValue()));
            this.object.setStatusObject(0L);
        } else if (this.radioColorObject.getSelection()) {
            this.object.setColor(-1);
            this.object.setStatusObject(this.statusObject.getObjectId());
        } else {
            this.object.setColor(-1);
            this.object.setStatusObject(0L);
        }
        this.object.setRoutingAlgorithm(this.routingAlgorithm.getSelectionIndex());
        this.object.update();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

