/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.util.List;
import java.util.UUID;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Subnet;
import org.netxms.ui.eclipse.imagelibrary.dialogs.ImageSelectionDialog;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.dialogs.AddGroupBoxDialog;
import org.netxms.ui.eclipse.networkmaps.views.NetworkMap;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkEditor;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class PredefinedMap
extends NetworkMap
implements ImageUpdateListener {
    public static final String ID = "org.netxms.ui.eclipse.networkmaps.views.PredefinedMap";
    private org.netxms.client.objects.NetworkMap mapObject;
    private Action actionAddObject;
    private Action actionLinkObjects;
    private Action actionAddGroupBox;
    private Action actionAddImage;
    private Action actionRemove;
    private Action actionMapProperties;
    private Action actionLinkProperties;
    private Color backgroundColor = null;
    private Color defaultLinkColor = null;

    public PredefinedMap() {
        this.allowManualLayout = true;
    }

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.mapObject = (org.netxms.client.objects.NetworkMap)this.rootObject;
        this.setPartName(this.rootObject.getObjectName());
        if (this.mapObject.getLayout() == Short.MAX_VALUE) {
            this.automaticLayoutEnabled = false;
        } else {
            this.automaticLayoutEnabled = true;
            this.layoutAlgorithm = this.mapObject.getLayout();
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PredefinedMap.this.actionLinkObjects.setEnabled(((IStructuredSelection)event.getSelection()).size() == 2);
            }
        });
        if (this.mapObject.getMapType() == 0) {
            this.addDropSupport();
        }
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
        if (this.mapObject.getBackground() != null && this.mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (this.mapObject.getBackground().equals(org.netxms.client.objects.NetworkMap.GEOMAP_BACKGROUND)) {
                this.viewer.setBackgroundImage(this.mapObject.getBackgroundLocation(), this.mapObject.getBackgroundZoom());
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(this.mapObject.getBackground()));
            }
        }
        this.setConnectionRouter(this.mapObject.getDefaultLinkRouting());
        this.backgroundColor = new Color((Device)this.viewer.getGraphControl().getDisplay(), ColorConverter.rgbFromInt((int)this.mapObject.getBackgroundColor()));
        this.viewer.getControl().setBackground(this.backgroundColor);
        if (this.mapObject.getDefaultLinkColor() >= 0) {
            this.defaultLinkColor = new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)this.mapObject.getDefaultLinkColor()));
            this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        }
        this.labelProvider.setShowStatusBackground((this.mapObject.getFlags() & 4) > 0);
        this.labelProvider.setShowStatusFrame((this.mapObject.getFlags() & 2) > 0);
        this.labelProvider.setShowStatusIcons((this.mapObject.getFlags() & 1) > 0);
        this.refreshMap();
    }

    private void addDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(3, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){
            private int x;
            private int y;

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (!LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                    return false;
                }
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                for (Object object : selection) {
                    if (object instanceof Node || object instanceof Container || object instanceof Subnet || object instanceof Condition) continue;
                    return false;
                }
                return true;
            }

            public boolean performDrop(Object data) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                PredefinedMap.this.addObjectsFromList(selection.toList(), PredefinedMap.this.viewer.getControl().toControl(this.x, this.y));
                return true;
            }

            public void dropAccept(DropTargetEvent event) {
                this.x = event.x;
                this.y = event.y;
                super.dropAccept(event);
            }
        });
    }

    @Override
    protected void buildMapPage() {
        this.mapPage = ((org.netxms.client.objects.NetworkMap)this.rootObject).createMapPage();
    }

    @Override
    protected void createActions() {
        super.createActions();
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionAddObject = new Action("&Add object..."){

            public void run() {
                PredefinedMap.this.addObjectToMap();
            }
        };
        this.actionAddObject.setId("org.netxms.ui.eclipse.networkmaps.localActions.PredefinedMap.AddObject");
        this.actionAddObject.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.PredefinedMap.AddObject");
        ActionHandler addObjectHandler = new ActionHandler((IAction)this.actionAddObject);
        handlerService.activateHandler(this.actionAddObject.getActionDefinitionId(), (IHandler)addObjectHandler);
        this.actionAddGroupBox = new Action("&Group box..."){

            public void run() {
                PredefinedMap.this.addGroupBoxDecoration();
            }
        };
        this.actionAddImage = new Action("&Image..."){

            public void run() {
                PredefinedMap.this.addImageDecoration();
            }
        };
        this.actionLinkObjects = new Action("&Link selected objects", Activator.getImageDescriptor("icons/link_add.png")){

            public void run() {
                PredefinedMap.this.linkSelectedObjects();
            }
        };
        this.actionLinkObjects.setId("org.netxms.ui.eclipse.networkmaps.localActions.PredefinedMap.LinkObjects");
        this.actionLinkObjects.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.PredefinedMap.LinkObjects");
        ActionHandler linkObjectHandler = new ActionHandler((IAction)this.actionLinkObjects);
        handlerService.activateHandler(this.actionLinkObjects.getActionDefinitionId(), (IHandler)linkObjectHandler);
        this.actionRemove = new Action("&Remove from map", SharedIcons.DELETE_OBJECT){

            public void run() {
                PredefinedMap.this.removeSelectedElements();
            }
        };
        this.actionRemove.setId("org.netxms.ui.eclipse.networkmaps.localActions.PredefinedMap.Remove");
        this.actionRemove.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.PredefinedMap.Remove");
        ActionHandler removeHandler = new ActionHandler((IAction)this.actionRemove);
        handlerService.activateHandler(this.actionRemove.getActionDefinitionId(), (IHandler)removeHandler);
        this.actionMapProperties = new Action("Map &properties"){

            public void run() {
                PredefinedMap.this.showMapProperties();
            }
        };
        this.actionLinkProperties = new Action("&Properties"){

            public void run() {
                PredefinedMap.this.showLinkProperties();
            }
        };
    }

    private IMenuManager createDecorationAdditionSubmenu() {
        MenuManager menu = new MenuManager("Add &decoration");
        menu.add((IAction)this.actionAddGroupBox);
        menu.add((IAction)this.actionAddImage);
        return menu;
    }

    @Override
    protected void fillMapContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAddObject);
        manager.add((IContributionItem)this.createDecorationAdditionSubmenu());
        manager.add((IContributionItem)new Separator());
        super.fillMapContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionMapProperties);
    }

    @Override
    protected void fillObjectContextMenu(IMenuManager manager) {
        int size = ((IStructuredSelection)this.viewer.getSelection()).size();
        if (size == 2) {
            manager.add((IAction)this.actionLinkObjects);
        }
        manager.add((IAction)this.actionRemove);
        manager.add((IContributionItem)new Separator());
        super.fillObjectContextMenu(manager);
    }

    @Override
    protected void fillLinkContextMenu(IMenuManager manager) {
        int size = ((IStructuredSelection)this.viewer.getSelection()).size();
        manager.add((IAction)this.actionRemove);
        manager.add((IContributionItem)new Separator());
        super.fillLinkContextMenu(manager);
        if (size == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionLinkProperties);
        }
    }

    @Override
    protected void fillElementContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRemove);
        manager.add((IContributionItem)new Separator());
        super.fillElementContextMenu(manager);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAddObject);
        manager.add((IAction)this.actionLinkObjects);
        manager.add((IContributionItem)this.createDecorationAdditionSubmenu());
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionMapProperties);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionLinkObjects);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void saveLayout() {
        this.saveMap();
    }

    private void addObjectToMap() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, null);
        if (dlg.open() != 0) {
            return;
        }
        this.addObjectsFromList(dlg.getSelectedObjects(), null);
    }

    private void addObjectsFromList(List<GenericObject> list, Point location) {
        int added = 0;
        for (GenericObject object : list) {
            if (this.mapPage.findObjectElement(object.getObjectId()) != null) continue;
            NetworkMapObject mapObject = new NetworkMapObject(this.mapPage.createElementId(), object.getObjectId());
            if (location != null) {
                mapObject.setLocation(location.x, location.y);
            }
            this.mapPage.addElement((NetworkMapElement)mapObject);
            ++added;
        }
        if (added > 0) {
            this.saveMap();
            this.viewer.setInput(this.mapPage);
        }
    }

    private void linkSelectedObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 2) {
            return;
        }
        Object[] objects = selection.toArray();
        long id1 = ((NetworkMapObject)objects[0]).getId();
        long id2 = ((NetworkMapObject)objects[1]).getId();
        if (!this.mapPage.areObjectsConnected(id1, id1)) {
            this.mapPage.addLink(new NetworkMapLink(0, id1, id2));
            this.saveMap();
        }
    }

    private void removeSelectedElements() {
        Object[] objects;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Confirm Removal", (String)("Are you sure to remove selected element" + (selection.size() == 1 ? "" : "s") + " from map?"))) {
            return;
        }
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof GenericObject) {
                this.mapPage.removeObjectElement(((GenericObject)element).getObjectId());
            } else if (element instanceof NetworkMapElement) {
                this.mapPage.removeElement(((NetworkMapElement)element).getId());
            } else if (element instanceof NetworkMapLink) {
                this.mapPage.removeLink((NetworkMapLink)element);
            }
            ++n2;
        }
        this.saveMap();
    }

    private void addGroupBoxDecoration() {
        AddGroupBoxDialog dlg = new AddGroupBoxDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        NetworkMapDecoration element = new NetworkMapDecoration(this.mapPage.createElementId(), 0);
        element.setSize(dlg.getWidth(), dlg.getHeight());
        element.setTitle(dlg.getTitle());
        element.setColor(ColorConverter.rgbToInt((RGB)dlg.getColor()));
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void addImageDecoration() {
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        UUID imageGuid = dlg.getLibraryImage().getGuid();
        Rectangle imageBounds = dlg.getImage().getBounds();
        NetworkMapDecoration element = new NetworkMapDecoration(this.mapPage.createElementId(), 1);
        element.setSize(imageBounds.width, imageBounds.height);
        element.setTitle(imageGuid.toString());
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void saveMap() {
        this.updateObjectPositions();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.rootObject.getObjectId());
        md.setMapContent(this.mapPage.getElements(), this.mapPage.getLinks());
        md.setMapLayout(this.automaticLayoutEnabled ? this.layoutAlgorithm : Short.MAX_VALUE);
        new ConsoleJob("Save map object " + this.rootObject.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.networkmaps", "org.netxms.ui.eclipse.networkmaps"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PredefinedMap.this.session.modifyObject(md);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).PredefinedMap.this.viewer.setInput((this).PredefinedMap.this.mapPage);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot update map content on server";
            }
        }.start();
    }

    private void showMapProperties() {
        this.updateObjectPositions();
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)this.mapObject);
        dlg.open();
    }

    @Override
    protected boolean isSelectableElement(Object element) {
        return element instanceof NetworkMapDecoration || element instanceof NetworkMapLink;
    }

    public void imageUpdated(final UUID guid) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (guid.equals(PredefinedMap.this.mapObject.getBackground())) {
                    PredefinedMap.this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(guid));
                }
                String guidText = guid.toString();
                for (NetworkMapElement e : PredefinedMap.this.mapPage.getElements()) {
                    if (!(e instanceof NetworkMapDecoration) || ((NetworkMapDecoration)e).getDecorationType() != 1 || !((NetworkMapDecoration)e).getTitle().equals(guidText)) continue;
                    PredefinedMap.this.viewer.updateDecorationFigure((NetworkMapDecoration)e);
                    break;
                }
            }
        });
    }

    @Override
    public void dispose() {
        ImageProvider.getInstance().removeUpdateListener((ImageUpdateListener)this);
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        if (this.defaultLinkColor != null) {
            this.defaultLinkColor.dispose();
        }
        super.dispose();
    }

    @Override
    protected void onObjectChange(GenericObject object) {
        super.onObjectChange(object);
        if (object.getObjectId() != this.mapObject.getObjectId()) {
            return;
        }
        UUID oldBackground = this.mapObject.getBackground();
        this.mapObject = (org.netxms.client.objects.NetworkMap)object;
        if (!oldBackground.equals(this.mapObject.getBackground()) || this.mapObject.getBackground().equals(org.netxms.client.objects.NetworkMap.GEOMAP_BACKGROUND)) {
            if (this.mapObject.getBackground().equals(NXCommon.EMPTY_GUID)) {
                this.viewer.setBackgroundImage(null);
            } else if (this.mapObject.getBackground().equals(org.netxms.client.objects.NetworkMap.GEOMAP_BACKGROUND)) {
                this.viewer.setBackgroundImage(this.mapObject.getBackgroundLocation(), this.mapObject.getBackgroundZoom());
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(this.mapObject.getBackground()));
            }
        }
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        this.backgroundColor = new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)this.mapObject.getBackgroundColor()));
        this.viewer.getGraphControl().setBackground(this.backgroundColor);
        this.setConnectionRouter(this.mapObject.getDefaultLinkRouting());
        if (this.defaultLinkColor != null) {
            this.defaultLinkColor.dispose();
        }
        this.defaultLinkColor = this.mapObject.getDefaultLinkColor() >= 0 ? new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)this.mapObject.getDefaultLinkColor())) : null;
        this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        if (this.mapObject.getBackground() != null && this.mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (this.mapObject.getBackground().equals(org.netxms.client.objects.NetworkMap.GEOMAP_BACKGROUND)) {
                this.viewer.setBackgroundImage(this.mapObject.getBackgroundLocation(), this.mapObject.getBackgroundZoom());
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(this.mapObject.getBackground()));
            }
        }
        this.setLayoutAlgorithm(this.mapObject.getLayout(), false);
        this.labelProvider.setShowStatusBackground((this.mapObject.getFlags() & 4) > 0);
        this.labelProvider.setShowStatusFrame((this.mapObject.getFlags() & 2) > 0);
        this.labelProvider.setShowStatusIcons((this.mapObject.getFlags() & 1) > 0);
        this.refreshMap();
    }

    private void showLinkProperties() {
        this.updateObjectPositions();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapLink)) {
            return;
        }
        LinkEditor link = new LinkEditor((NetworkMapLink)selection.getFirstElement(), this.mapPage);
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)link);
        if (dlg != null) {
            dlg.open();
            if (link.isModified()) {
                this.saveMap();
            }
        }
    }
}

