/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.resource.JFaceResources;
import org.netxms.client.MacAddress;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.figures.BirtChartFigure;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class ObjectTooltip
extends Figure {
    public ObjectTooltip(GenericObject object, MapLabelProvider labelProvider) {
        this.setBorder((Border)new MarginBorder(3));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        this.setLayoutManager((LayoutManager)layout);
        Label title = new Label();
        title.setIcon(labelProvider.getWorkbenchIcon(object));
        title.setText(object.getObjectName());
        title.setFont(JFaceResources.getBannerFont());
        this.add((IFigure)title);
        Label status = new Label();
        status.setIcon(StatusDisplayInfo.getStatusImage((int)object.getStatus()));
        status.setText(StatusDisplayInfo.getStatusText((int)object.getStatus()));
        this.add((IFigure)status);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.setConstraint((IFigure)status, gd);
        if (object instanceof Node && !((Node)object).getPrimaryIP().isAnyLocalAddress()) {
            StringBuilder sb = new StringBuilder(((Node)object).getPrimaryIP().getHostAddress());
            MacAddress mac = ((Node)object).getPrimaryMAC();
            if (mac != null) {
                sb.append(" (");
                sb.append(mac.toString());
                sb.append(')');
            }
            Label iface = new Label();
            iface.setIcon(SharedIcons.IMG_IP_ADDRESS);
            iface.setText(sb.toString());
            this.add((IFigure)iface);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)iface, gd);
        }
        if (object instanceof Container) {
            this.addStatusChart(object, labelProvider);
        }
        if (!object.getComments().isEmpty()) {
            FlowPage page = new FlowPage();
            this.add((IFigure)page);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)page, gd);
            TextFlow text = new TextFlow();
            text.setText("\n" + object.getComments());
            page.add((IFigure)text);
        }
    }

    private void addStatusChart(GenericObject object, MapLabelProvider labelProvider) {
        BirtChartFigure chart = new BirtChartFigure(0, labelProvider.getColors());
        this.add((IFigure)chart);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.heightHint = 180;
        gd.widthHint = 320;
        this.setConstraint((IFigure)chart, gd);
        int[] objectCount = new int[6];
        this.collectData(objectCount, object);
        chart.setTitleVisible(true);
        chart.setChartTitle("Underlying Nodes Status");
        chart.setLegendPosition(2);
        chart.setLegendVisible(true);
        chart.set3DModeEnabled(true);
        chart.setTransposed(false);
        chart.setTranslucent(false);
        chart.setBorder((Border)new LineBorder());
        int i = 0;
        while (i <= 5) {
            chart.addParameter(new GraphItem(0L, 0L, 0, 0, StatusDisplayInfo.getStatusText((int)i), StatusDisplayInfo.getStatusText((int)i)), (double)objectCount[i]);
            chart.setPaletteEntry(i, new ChartColor(StatusDisplayInfo.getStatusColor((int)i).getRGB()));
            ++i;
        }
        chart.initializationComplete();
    }

    private void collectData(int[] objectCount, GenericObject root) {
        for (GenericObject o : root.getAllChilds(2)) {
            if (o.getStatus() > 5) continue;
            int n = o.getStatus();
            objectCount[n] = objectCount[n] + 1;
        }
    }
}

