/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.DciList;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SelectNodeDciDialog
extends Dialog {
    private long nodeId;
    private DciList dciList;
    private DciValue selection;
    private int dcObjectType = -1;

    public SelectNodeDciDialog(Shell parentShell, long nodeId) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.nodeId = nodeId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SelectNodeDciDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectNodeDciDialog.cx"), settings.getInt("SelectNodeDciDialog.cy"));
        }
        catch (NumberFormatException numberFormatException) {
            newShell.setSize(400, 250);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        this.dciList = new DciList(null, dialogArea, 2048, null, "SelectNodeDciDialog.dciList", this.dcObjectType);
        this.dciList.setDcObjectType(this.dcObjectType);
        this.dciList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectNodeDciDialog.this.okPressed();
            }
        });
        this.dciList.setNode((GenericObject)((Node)((NXCSession)ConsoleSharedData.getSession()).findObjectById(this.nodeId, Node.class)));
        return dialogArea;
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectNodeDciDialog.cx", size.x);
        settings.put("SelectNodeDciDialog.cy", size.y);
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.selection = this.dciList.getSelection();
        if (this.selection == null) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)Messages.SelectNodeDciDialog_Warning, (String)Messages.SelectNodeDciDialog_WarningText);
            return;
        }
        this.saveSettings();
        super.okPressed();
    }

    public DciValue getSelection() {
        return this.selection;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
        if (this.dciList != null) {
            this.dciList.setDcObjectType(dcObjectType);
        }
    }
}

