/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.EditScheduleDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.tools.StringComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class CustomSchedule
extends PropertyPage {
    private DataCollectionObject dci;
    private HashSet<String> schedules;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;

    protected Control createContents(Composite parent) {
        this.dci = (DataCollectionObject)this.getElement().getAdapter(DataCollectionObject.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{Messages.CustomSchedule_Schedule};
        int[] columnWidths = new int[]{300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new StringComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    CustomSchedule.this.editButton.setEnabled(selection.size() == 1);
                    CustomSchedule.this.deleteButton.setEnabled(selection.size() > 0);
                }
            }
        });
        this.schedules = new HashSet();
        this.schedules.addAll(this.dci.getSchedules());
        this.viewer.setInput((Object)this.schedules.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.marginBottom = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.spacing = 4;
        buttonLayout.fill = true;
        buttonLayout.pack = false;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Messages.CustomSchedule_Add);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CustomSchedule.this.addSchedule();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(Messages.CustomSchedule_Edit);
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CustomSchedule.this.editSchedule();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(Messages.CustomSchedule_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CustomSchedule.this.deleteSchedules();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CustomSchedule.this.editButton.notifyListeners(13, new Event());
            }
        });
        return dialogArea;
    }

    private void addSchedule() {
        EditScheduleDialog dlg = new EditScheduleDialog(this.getShell(), "");
        if (dlg.open() == 0) {
            this.schedules.add(dlg.getSchedule());
            this.viewer.setInput((Object)this.schedules.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)dlg.getSchedule()));
        }
    }

    private void editSchedule() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String oldValue = new String((String)selection.getFirstElement());
        EditScheduleDialog dlg = new EditScheduleDialog(this.getShell(), (String)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.schedules.remove(oldValue);
            this.schedules.add(dlg.getSchedule());
            this.viewer.setInput((Object)this.schedules.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)dlg.getSchedule()));
        }
    }

    private void deleteSchedules() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.schedules.remove(it.next());
        }
        this.viewer.setInput((Object)this.schedules.toArray());
    }

    protected void applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        this.dci.setSchedules(this.schedules);
        new ConsoleJob(String.valueOf(Messages.CustomSchedule_JobTitle) + this.dci.getId(), null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                CustomSchedule.this.dci.getOwner().modifyObject(CustomSchedule.this.dci);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        CustomSchedule.this.setValid(true);
                    }
                });
            }

            protected String getErrorMessage() {
                return Messages.CustomSchedule_JobError;
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.schedules.clear();
        this.viewer.setInput((Object)this.schedules.toArray());
    }
}

