/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class InstanceDiscovery
extends PropertyPage {
    private static final String[] DCI_FUNCTIONS = new String[]{"FindDCIByName", "FindDCIByDescription", "GetDCIObject", "GetDCIValue", "GetDCIValueByDescription", "GetDCIValueByName"};
    private static final String[] DCI_VARIABLES = new String[]{"$dci", "$node"};
    private DataCollectionItem dci;
    private Combo discoveryMethod;
    private LabeledText discoveryData;
    private ScriptEditor filterScript;

    protected Control createContents(Composite parent) {
        this.dci = (DataCollectionItem)this.getElement().getAdapter(DataCollectionItem.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.discoveryMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)"Instance discovery method", (Object)"WidgetHelper::default_layout_data");
        this.discoveryMethod.add("None");
        this.discoveryMethod.add("Agent List");
        this.discoveryMethod.add("Agent Table");
        this.discoveryMethod.add("SNMP Walk - Values");
        this.discoveryMethod.add("SNMP Walk - OIDs");
        this.discoveryMethod.select(this.dci.getInstanceDiscoveryMethod());
        this.discoveryMethod.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int method = InstanceDiscovery.this.discoveryMethod.getSelectionIndex();
                InstanceDiscovery.this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(method));
                InstanceDiscovery.this.discoveryData.setEnabled(method != 0);
                InstanceDiscovery.this.filterScript.setEnabled(method != 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.discoveryData = new LabeledText(dialogArea, 0);
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(this.dci.getInstanceDiscoveryMethod()));
        this.discoveryData.setText(this.dci.getInstanceDiscoveryData());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.discoveryData.setLayoutData((Object)gd);
        this.discoveryData.setEnabled(this.dci.getInstanceDiscoveryMethod() != 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 0;
        gd.heightHint = 0;
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new ScriptEditor(parent, style, 768);
            }
        };
        this.filterScript = (ScriptEditor)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)2048, (WidgetFactory)factory, (String)"Instance discovery filter script", (Object)gd);
        this.filterScript.addFunctions(Arrays.asList(DCI_FUNCTIONS));
        this.filterScript.addVariables(Arrays.asList(DCI_VARIABLES));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.filterScript.setLayoutData((Object)gd);
        this.filterScript.setText(this.dci.getInstanceDiscoveryFilter());
        this.filterScript.setEnabled(this.dci.getInstanceDiscoveryMethod() != 0);
        return dialogArea;
    }

    private static String getDataLabel(int method) {
        switch (method) {
            case 0: {
                return "Discovery data";
            }
            case 1: {
                return "List name";
            }
            case 2: {
                return "List name";
            }
            case 3: 
            case 4: {
                return "Base SNMP OID";
            }
        }
        return "";
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        this.dci.setInstanceDiscoveryMethod(this.discoveryMethod.getSelectionIndex());
        this.dci.setInstanceDiscoveryData(this.discoveryData.getText());
        this.dci.setInstanceDiscoveryFilter(this.filterScript.getText());
        new ConsoleJob("Updating instance discovery configuration for DCI " + this.dci.getId(), null, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                return "Cannot update instance discovery configuration";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                InstanceDiscovery.this.dci.getOwner().modifyObject((DataCollectionObject)InstanceDiscovery.this.dci);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ((TableViewer)InstanceDiscovery.this.dci.getOwner().getUserData()).update((Object)InstanceDiscovery.this.dci, null);
                    }
                });
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            InstanceDiscovery.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.discoveryMethod.select(0);
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(0));
        this.discoveryData.setText("");
        this.discoveryData.setEnabled(false);
        this.filterScript.setText("");
        this.filterScript.setEnabled(false);
    }
}

