/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.widgets;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.SnmpConstants;
import org.netxms.ui.eclipse.snmp.shared.MibCache;
import org.netxms.ui.eclipse.snmp.widgets.MibBrowser;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class MibObjectDetails
extends Composite {
    private Text oid;
    private Text oidText;
    private Text description;
    private Text textualConvention;
    private Text type;
    private Text status;
    private Text access;
    private MibBrowser mibTree;
    private boolean updateObjectId = true;

    public MibObjectDetails(Composite parent, int style, boolean showOID, MibBrowser mibTree) {
        super(parent, style);
        this.mibTree = mibTree;
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        if (showOID) {
            this.oid = WidgetHelper.createLabeledText((Composite)this, (int)2048, (int)500, (String)Messages.MibObjectDetails_OID, (String)"", (Object)"WidgetHelper::default_layout_data");
            this.oid.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MibObjectDetails.this.onManualOidChange();
                }
            });
            this.oidText = WidgetHelper.createLabeledText((Composite)this, (int)2048, (int)500, (String)"OID as text", (String)"", (Object)"WidgetHelper::default_layout_data");
            this.oidText.setEditable(false);
        } else {
            this.oid = null;
        }
        Composite infoGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        infoGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        infoGroup.setLayoutData((Object)gd);
        this.type = WidgetHelper.createLabeledText((Composite)infoGroup, (int)2056, (int)-1, (String)Messages.MibObjectDetails_Type, (String)"", (Object)"WidgetHelper::default_layout_data");
        this.status = WidgetHelper.createLabeledText((Composite)infoGroup, (int)2056, (int)-1, (String)Messages.MibObjectDetails_Status, (String)"", (Object)"WidgetHelper::default_layout_data");
        this.access = WidgetHelper.createLabeledText((Composite)infoGroup, (int)2056, (int)-1, (String)Messages.MibObjectDetails_Access, (String)"", (Object)"WidgetHelper::default_layout_data");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.description = WidgetHelper.createLabeledText((Composite)this, (int)2826, (int)500, (String)Messages.MibObjectDetails_8, (String)"", (Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.heightHint = 150;
        this.description.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.textualConvention = WidgetHelper.createLabeledText((Composite)this, (int)2826, (int)500, (String)"Textual Convention", (String)"", (Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.heightHint = 150;
        this.textualConvention.setLayoutData((Object)gd);
    }

    private void onManualOidChange() {
        MibObject o = MibCache.findObject(this.oid.getText(), false);
        if (o != null && this.mibTree != null) {
            this.updateObjectId = false;
            this.mibTree.setSelection(o);
            this.updateObjectId = true;
        }
    }

    public void setObject(MibObject object) {
        if (object != null) {
            if (this.oid != null && this.updateObjectId) {
                SnmpObjectId objectId = object.getObjectId();
                this.oid.setText(objectId != null ? objectId.toString() : "");
            }
            if (this.oidText != null) {
                this.oidText.setText(object.getFullName());
            }
            this.description.setText(object.getDescription());
            this.textualConvention.setText(object.getTextualConvention());
            this.type.setText(SnmpConstants.getObjectTypeName(object.getType()));
            this.status.setText(SnmpConstants.getObjectStatusName(object.getStatus()));
            this.access.setText(SnmpConstants.getObjectAccessName(object.getAccess()));
        } else {
            if (this.oid != null) {
                this.oid.setText("");
            }
            if (this.oidText != null) {
                this.oidText.setText("");
            }
            this.description.setText("");
            this.textualConvention.setText("");
            this.type.setText("");
            this.status.setText("");
            this.access.setText("");
        }
    }
}

