/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.widgets.internal;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.nxsl.widgets.internal.KeywordRule;
import org.netxms.ui.eclipse.nxsl.widgets.internal.NXSLDocument;
import org.netxms.ui.eclipse.nxsl.widgets.internal.NXSLProposalProcessor;
import org.netxms.ui.eclipse.nxsl.widgets.internal.NXSLTextAttributeProvider;
import org.netxms.ui.eclipse.nxsl.widgets.internal.SingleTokenScanner;

public class NXSLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private ScriptEditor scriptEditor;
    private static final IWordDetector nxslWordDetector = new IWordDetector(){

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '$' || c == '_';
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c) || c == '$' || c == '_';
        }
    };
    private static final String[] nxslKeywords = new String[]{"break", "classof", "continue", "do", "else", "exit", "for", "foreach", "if", "ilike", "imatch", "int32", "int64", "like", "match", "print", "println", "real", "return", "string", "sub", "typeof", "uint32", "uint64", "use", "while"};
    private static final IRule[] codeRules = new IRule[]{new KeywordRule(nxslWordDetector, NXSLTextAttributeProvider.getTextAttributeToken(4), NXSLTextAttributeProvider.getTextAttributeToken(0), nxslKeywords)};

    public NXSLSourceViewerConfiguration(ScriptEditor scriptEditor) {
        this.scriptEditor = scriptEditor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        NXSLProposalProcessor processor = new NXSLProposalProcessor(this.scriptEditor);
        ContentAssistant ca = new ContentAssistant();
        ca.enableAutoActivation(true);
        ca.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return ca;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 3;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return NXSLDocument.NXSL_CONTENT_TYPES;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(codeRules);
        scanner.setDefaultReturnToken(NXSLTextAttributeProvider.getTextAttributeToken(0));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(NXSLTextAttributeProvider.getTextAttribute(1)));
        reconciler.setDamager((IPresentationDamager)dr, "COMMENTS");
        reconciler.setRepairer((IPresentationRepairer)dr, "COMMENTS");
        scanner = new RuleBasedScanner();
        scanner.setRules(new IRule[]{new PatternRule("\"", "\n", NXSLTextAttributeProvider.getTextAttributeToken(3), '\u0000', false)});
        scanner.setDefaultReturnToken(NXSLTextAttributeProvider.getTextAttributeToken(5));
        dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "STRING");
        reconciler.setRepairer((IPresentationRepairer)dr, "STRING");
        return reconciler;
    }
}

