/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;

public class Table {
    private String title;
    private String instanceColumn;
    private List<String> columnNames;
    private List<Integer> columnFormats;
    private List<List<String>> data;

    public Table() {
        this.title = "untitled";
        this.instanceColumn = null;
        this.columnNames = new ArrayList<String>(0);
        this.columnFormats = new ArrayList<Integer>(0);
        this.data = new ArrayList<List<String>>(0);
    }

    public Table(NXCPMessage msg) {
        this.title = msg.getVariableAsString(168L);
        this.instanceColumn = msg.getVariableAsString(412L);
        int columnCount = msg.getVariableAsInteger(329L);
        this.columnNames = new ArrayList<String>(columnCount);
        this.columnFormats = new ArrayList<Integer>(columnCount);
        long varId = 0x10000000L;
        int i = 0;
        while (i < columnCount) {
            this.columnNames.add(msg.getVariableAsString(varId++));
            this.columnFormats.add(msg.getVariableAsInteger(varId++));
            ++i;
            varId += 8L;
        }
        int totalRowCount = msg.getVariableAsInteger(328L);
        this.data = new ArrayList<List<String>>(totalRowCount);
        int rowCount = msg.getVariableAsInteger(167L);
        varId = 0x20000000L;
        int i2 = 0;
        while (i2 < rowCount) {
            ArrayList<String> row = new ArrayList<String>(columnCount);
            int j = 0;
            while (j < columnCount) {
                row.add(msg.getVariableAsString(varId++));
                ++j;
            }
            this.data.add(row);
            ++i2;
        }
    }

    public void addDataFromMessage(NXCPMessage msg) {
        int rowCount = msg.getVariableAsInteger(167L);
        long varId = 0x20000000L;
        int i = 0;
        while (i < rowCount) {
            ArrayList<String> row = new ArrayList<String>(this.columnNames.size());
            int j = 0;
            while (j < this.columnNames.size()) {
                row.add(msg.getVariableAsString(varId++));
                ++j;
            }
            this.data.add(row);
            ++i;
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setVariable(168L, this.title);
        if (this.instanceColumn != null) {
            msg.setVariable(412L, this.instanceColumn);
        }
        int columnCount = this.columnNames.size();
        msg.setVariableInt32(329L, columnCount);
        long varId = 0x10000000L;
        int i = 0;
        while (i < columnCount) {
            msg.setVariable(varId++, this.columnNames.get(i));
            msg.setVariableInt32(varId++, this.columnFormats.get(i));
            ++i;
            varId += 8L;
        }
        msg.setVariableInt32(328L, this.data.size());
        varId = 0x20000000L;
        int row = 0;
        while (row < this.data.size()) {
            List<String> rowData = this.data.get(row);
            int col = 0;
            while (col < columnCount) {
                msg.setVariable(varId++, rowData.get(col));
                ++col;
            }
            ++row;
        }
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int column) throws IndexOutOfBoundsException {
        return this.columnNames.get(column);
    }

    public int getColumnFormat(int column) throws IndexOutOfBoundsException {
        return this.columnFormats.get(column);
    }

    public int getColumnIndex(String name) {
        return this.columnNames.indexOf(name);
    }

    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public Integer[] getColumnFormats() {
        return this.columnFormats.toArray(new Integer[this.columnFormats.size()]);
    }

    public String getCell(int row, int column) throws IndexOutOfBoundsException {
        List<String> rowData = this.data.get(row);
        return rowData.get(column);
    }

    public List<String> getRow(int row) throws IndexOutOfBoundsException {
        return this.data.get(row);
    }

    public Object[] getAllRows() {
        Object[] rows = new Object[this.data.size()];
        int i = 0;
        while (i < rows.length) {
            rows[i] = this.data.get(i);
            ++i;
        }
        return rows;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Table");
        sb.append("{columns=").append(this.columnNames);
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }

    public String getInstanceColumn() {
        return this.instanceColumn;
    }

    public void setInstanceColumn(String instanceColumn) {
        this.instanceColumn = instanceColumn;
    }

    public void addAll(Table src) {
        this.data.addAll(src.data);
    }

    public void addRow() {
        ArrayList<String> row = new ArrayList<String>(this.columnNames.size());
        int i = 0;
        while (i < this.columnNames.size()) {
            row.add("");
            ++i;
        }
        this.data.add(row);
    }

    public void setCell(int row, int col, String value) {
        if (row >= 0 && row < this.data.size() && col >= 0 && col < this.columnNames.size()) {
            this.data.get(row).set(col, value);
        }
    }
}

