/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import org.netxms.base.NXCPMessage;

public class SnmpUsmCredential {
    private String name;
    private int authMethod;
    private int privMethod;
    private String authPassword;
    private String privPassword;

    public SnmpUsmCredential(NXCPMessage msg, long baseId) {
        this.name = msg.getVariableAsString(baseId);
        this.authMethod = msg.getVariableAsInteger(baseId + 1L);
        this.privMethod = msg.getVariableAsInteger(baseId + 2L);
        this.authPassword = msg.getVariableAsString(baseId + 3L);
        this.privPassword = msg.getVariableAsString(baseId + 4L);
    }

    public SnmpUsmCredential() {
        this.name = "";
        this.authMethod = 0;
        this.privMethod = 0;
        this.authPassword = "";
        this.privPassword = "";
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setVariable(baseId, this.name);
        msg.setVariableInt16(baseId + 1L, this.authMethod);
        msg.setVariableInt16(baseId + 2L, this.privMethod);
        msg.setVariable(baseId + 3L, this.authPassword);
        msg.setVariable(baseId + 4L, this.privPassword);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(int authMethod) {
        this.authMethod = authMethod;
    }

    public int getPrivMethod() {
        return this.privMethod;
    }

    public void setPrivMethod(int privMethod) {
        this.privMethod = privMethod;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getPrivPassword() {
        return this.privPassword;
    }

    public void setPrivPassword(String privPassword) {
        this.privPassword = privPassword;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.authMethod;
        result = 31 * result + (this.authPassword == null ? 0 : this.authPassword.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.privMethod;
        result = 31 * result + (this.privPassword == null ? 0 : this.privPassword.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnmpUsmCredential other = (SnmpUsmCredential)obj;
        if (this.authMethod != other.authMethod) {
            return false;
        }
        if (this.authPassword == null ? other.authPassword != null : !this.authPassword.equals(other.authPassword)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.privMethod != other.privMethod) {
            return false;
        }
        return !(this.privPassword == null ? other.privPassword != null : !this.privPassword.equals(other.privPassword));
    }
}

