/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Collection;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.DataCollectionConfiguration;

public abstract class DataCollectionObject {
    public static final int DCO_TYPE_GENERIC = 0;
    public static final int DCO_TYPE_ITEM = 1;
    public static final int DCO_TYPE_TABLE = 2;
    public static final int INTERNAL = 0;
    public static final int AGENT = 1;
    public static final int SNMP = 2;
    public static final int CHECKPOINT_SNMP = 3;
    public static final int PUSH = 4;
    public static final int WINPERF = 5;
    public static final int ILO = 6;
    public static final int ACTIVE = 0;
    public static final int DISABLED = 1;
    public static final int NOT_SUPPORTED = 2;
    public static final int DT_INT = 0;
    public static final int DT_UINT = 1;
    public static final int DT_INT64 = 2;
    public static final int DT_UINT64 = 3;
    public static final int DT_STRING = 4;
    public static final int DT_FLOAT = 5;
    public static final int DT_NULL = 6;
    public static final int DCF_ADVANCED_SCHEDULE = 1;
    public static final int DCF_AGGREGATE_ON_CLUSTER = 128;
    protected DataCollectionConfiguration owner;
    protected long id;
    protected long templateId;
    protected long resourceId;
    protected long proxyNode;
    protected int pollingInterval;
    protected int retentionTime;
    protected int origin;
    protected int status;
    protected int flags;
    protected String transformationScript;
    protected String name;
    protected String description;
    protected String systemTag;
    protected String perfTabSettings;
    protected int snmpPort;
    protected ArrayList<String> schedules;
    protected Object userData;

    protected DataCollectionObject(DataCollectionConfiguration owner, NXCPMessage msg) {
        this.owner = owner;
        this.id = msg.getVariableAsInt64(43L);
        this.templateId = msg.getVariableAsInt64(153L);
        this.resourceId = msg.getVariableAsInt64(266L);
        this.proxyNode = msg.getVariableAsInt64(195L);
        this.pollingInterval = msg.getVariableAsInteger(44L);
        this.retentionTime = msg.getVariableAsInteger(45L);
        this.origin = msg.getVariableAsInteger(46L);
        this.status = msg.getVariableAsInteger(48L);
        this.flags = msg.getVariableAsInteger(13L);
        this.transformationScript = msg.getVariableAsString(106L);
        this.name = msg.getVariableAsString(20L);
        this.description = msg.getVariableAsString(27L);
        this.systemTag = msg.getVariableAsString(346L);
        this.perfTabSettings = msg.getVariableAsString(325L);
        this.snmpPort = msg.getVariableAsInteger(80L);
        int count = msg.getVariableAsInteger(182L);
        this.schedules = new ArrayList(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            this.schedules.add(msg.getVariableAsString(varId));
            ++i;
            ++varId;
        }
    }

    protected DataCollectionObject(DataCollectionConfiguration owner, long id) {
        this.owner = owner;
        this.id = id;
        this.templateId = 0L;
        this.resourceId = 0L;
        this.proxyNode = 0L;
        this.pollingInterval = owner.getSession().getDefaultDciPollingInterval();
        this.retentionTime = owner.getSession().getDefaultDciRetentionTime();
        this.origin = 1;
        this.status = 0;
        this.flags = 0;
        this.transformationScript = null;
        this.perfTabSettings = null;
        this.name = "";
        this.description = "";
        this.systemTag = "";
        this.snmpPort = 0;
        this.schedules = new ArrayList(0);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setVariableInt32(43L, (int)this.id);
        msg.setVariableInt32(44L, this.pollingInterval);
        msg.setVariableInt32(45L, this.retentionTime);
        msg.setVariableInt16(46L, this.origin);
        msg.setVariableInt16(48L, this.status);
        msg.setVariable(20L, this.name);
        msg.setVariable(27L, this.description);
        msg.setVariable(346L, this.systemTag);
        msg.setVariableInt16(13L, this.flags);
        msg.setVariable(106L, this.transformationScript);
        msg.setVariableInt32(266L, (int)this.resourceId);
        msg.setVariableInt32(195L, (int)this.proxyNode);
        if (this.perfTabSettings != null) {
            msg.setVariable(325L, this.perfTabSettings);
        }
        msg.setVariableInt16(80L, this.snmpPort);
        msg.setVariableInt32(182L, this.schedules.size());
        long varId = 0x10000000L;
        for (int i = 0; i < this.schedules.size(); ++i) {
            msg.setVariable(varId++, this.schedules.get(i));
        }
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(long templateId) {
        this.templateId = templateId;
    }

    public long getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(long resourceId) {
        this.resourceId = resourceId;
    }

    public long getProxyNode() {
        return this.proxyNode;
    }

    public void setProxyNode(long proxyNode) {
        this.proxyNode = proxyNode;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int retentionTime) {
        this.retentionTime = retentionTime;
    }

    public int getOrigin() {
        return this.origin;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isUseAdvancedSchedule() {
        return (this.flags & 1) != 0;
    }

    public void setUseAdvancedSchedule(boolean useAdvancedSchedule) {
        this.flags = useAdvancedSchedule ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getId() {
        return this.id;
    }

    public ArrayList<String> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Collection<String> newSchedules) {
        this.schedules.clear();
        for (String s : newSchedules) {
            this.schedules.add(new String(s));
        }
    }

    public DataCollectionConfiguration getOwner() {
        return this.owner;
    }

    public long getNodeId() {
        return this.owner.getNodeId();
    }

    public String getSystemTag() {
        return this.systemTag;
    }

    public void setSystemTag(String systemTag) {
        this.systemTag = systemTag;
    }

    public String getPerfTabSettings() {
        return this.perfTabSettings;
    }

    public void setPerfTabSettings(String perfTabSettings) {
        this.perfTabSettings = perfTabSettings;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(int snmpPort) {
        this.snmpPort = snmpPort;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getTransformationScript() {
        return this.transformationScript;
    }

    public void setTransformationScript(String transformationScript) {
        this.transformationScript = transformationScript;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public boolean isAggregateOnCluster() {
        return (this.flags & 0x80) != 0;
    }

    public void setAggregateOnCluster(boolean enable) {
        this.flags = enable ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
    }
}

