/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.jface.preference.IPreferenceStore;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.Messages;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.DataChart;

public abstract class GenericChartFigure
extends Figure
implements DataChart {
    protected String title = Messages.GenericChart_Title0;
    protected boolean titleVisible = false;
    protected boolean legendVisible = true;
    protected boolean displayIn3D = true;
    protected boolean useLogScale = false;
    protected boolean translucent = false;
    protected ChartColor[] palette = null;
    protected IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    protected int legendPosition;

    public GenericChartFigure() {
        this.createDefaultPalette();
    }

    @Override
    public String getChartTitle() {
        return this.title;
    }

    @Override
    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    @Override
    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    @Override
    public void setPalette(ChartColor[] colors) {
        this.palette = colors;
    }

    @Override
    public void setPaletteEntry(int index, ChartColor color) {
        try {
            this.palette[index] = color;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    @Override
    public ChartColor getPaletteEntry(int index) {
        try {
            return this.palette[index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public boolean is3DModeEnabled() {
        return this.displayIn3D;
    }

    @Override
    public boolean isLogScaleEnabled() {
        return this.useLogScale;
    }

    protected void createDefaultPalette() {
        this.palette = new ChartColor[16];
        int i = 0;
        while (i < 16) {
            this.palette[i] = ChartColor.getDefaultColor(i);
            ++i;
        }
    }

    @Override
    public void setLegendPosition(int position) {
        this.legendPosition = position;
    }

    @Override
    public int getLegendPosition() {
        return this.legendPosition;
    }

    @Override
    public boolean isTranslucent() {
        return this.translucent;
    }

    @Override
    public void setTranslucent(boolean translucent) {
        this.translucent = translucent;
    }

    public void dispose() {
    }
}

