/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.MobileDevice;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.views.helpers.CellSelectionManager;
import org.netxms.ui.eclipse.perfview.views.helpers.TableContentProvider;
import org.netxms.ui.eclipse.perfview.views.helpers.TableItemComparator;
import org.netxms.ui.eclipse.perfview.views.helpers.TableLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableLastValues
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.TableLastValues";
    private NXCSession session;
    private long objectId;
    private String objectName;
    private long dciId;
    private long uniqueId = 1L;
    private Table currentData = null;
    private SortableTableViewer viewer;
    private CellSelectionManager cellSelectionManager;
    private Action actionRefresh;
    private Action actionExportAllToCsv;
    private Action actionShowLineChart;
    private Action actionShowBarChart;
    private Action actionShowPieChart;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.objectId = Long.parseLong(parts[0]);
        AbstractObject object = this.session.findObjectById(this.objectId);
        if (object == null || !(object instanceof AbstractNode) && !(object instanceof Cluster) && !(object instanceof MobileDevice)) {
            throw new PartInitException("Invalid object ID");
        }
        this.objectName = object.getObjectName();
        this.dciId = Long.parseLong(parts[1]);
        this.setPartName(String.valueOf(this.objectName) + ": [" + Long.toString(this.dciId) + "]");
    }

    public void createPartControl(Composite parent) {
        this.viewer = new SortableTableViewer(parent, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.cellSelectionManager = new CellSelectionManager(this.viewer);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refreshTable();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                TableLastValues.this.refreshTable();
            }
        };
        this.actionShowLineChart = new Action("&Line chart", Activator.getImageDescriptor("icons/chart_line.png")){

            public void run() {
                TableLastValues.this.showLineChart();
            }
        };
        this.actionShowBarChart = new Action("&Bar chart", Activator.getImageDescriptor("icons/chart_bar.png")){

            public void run() {
                TableLastValues.this.showDataComparisonChart(0);
            }
        };
        this.actionShowPieChart = new Action("&Pie chart", Activator.getImageDescriptor("icons/chart_pie.png")){

            public void run() {
                TableLastValues.this.showDataComparisonChart(1);
            }
        };
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableLastValues.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowLineChart);
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void refreshTable() {
        this.viewer.setInput(null);
        new ConsoleJob("Loading data for table DCI " + Long.toString(this.dciId), (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = TableLastValues.this.session.getTableLastValues(TableLastValues.this.objectId, TableLastValues.this.dciId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TableLastValues.this.setPartName(String.valueOf(TableLastValues.this.objectName) + ": " + table.getTitle());
                        TableLastValues.this.updateViewer(table);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get data for table DCI " + Long.toString(TableLastValues.this.dciId);
            }
        }.start();
    }

    private void updateViewer(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 150);
            this.viewer.createColumns(names, widths, 0, 128);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"TableLastValues");
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)TableLastValues.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"TableLastValues");
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        ((TableLabelProvider)this.viewer.getLabelProvider()).setColumns(table.getColumns());
        this.viewer.setInput((Object)table);
        this.currentData = table;
    }

    private String buildInstanceString(ViewerRow viewerRow) {
        StringBuilder instance = new StringBuilder();
        boolean first = true;
        int i = 0;
        while (i < this.currentData.getColumnCount()) {
            TableColumnDefinition cd = this.currentData.getColumnDefinition(i);
            if (cd.isInstanceColumn()) {
                if (!first) {
                    instance.append("~~~");
                }
                instance.append(viewerRow.getText(i));
                first = false;
            }
            ++i;
        }
        return instance.toString();
    }

    private void showLineChart() {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        String id = Long.toString(this.uniqueId++);
        int i = 0;
        while (i < cells.length) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            int source = this.currentData.getSource();
            id = String.valueOf(id) + "&" + Long.toString(this.objectId) + "@" + Long.toString(this.dciId) + "@" + Integer.toString(source) + "@" + Integer.toString(column.getDataType()) + "@" + TableLastValues.safeEncode(this.currentData.getTitle()) + "@" + TableLastValues.safeEncode(String.valueOf(column.getDisplayName()) + ": " + instance.replace("~~~", " / ")) + "@" + TableLastValues.safeEncode(instance) + "@" + TableLastValues.safeEncode(column.getName());
            ++i;
        }
        try {
            this.getSite().getPage().showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", id, 1);
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getSite().getShell(), (String)"Error", (String)String.format("Error opening view: %s", e.getLocalizedMessage()));
        }
    }

    private void showDataComparisonChart(int chartType) {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        String id = String.valueOf(Long.toString(this.uniqueId++)) + "&" + Integer.toString(chartType);
        int i = 0;
        while (i < cells.length) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            int source = this.currentData.getSource();
            id = String.valueOf(id) + "&" + Long.toString(this.objectId) + "@" + Long.toString(this.dciId) + "@" + Integer.toString(source) + "@" + Integer.toString(column.getDataType()) + "@" + TableLastValues.safeEncode(this.currentData.getTitle()) + "@" + TableLastValues.safeEncode(String.valueOf(column.getDisplayName()) + ": " + instance.replace("~~~", " / ")) + "@" + TableLastValues.safeEncode(instance) + "@" + TableLastValues.safeEncode(column.getName());
            ++i;
        }
        try {
            this.getSite().getPage().showView("org.netxms.ui.eclipse.perfview.views.DataComparisionView", id, 1);
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getSite().getShell(), (String)"Error", (String)String.format("Error opening view: %s", e.getLocalizedMessage()));
        }
    }

    private static String safeEncode(String text) {
        if (text == null) {
            return "";
        }
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "none";
        }
    }
}

