/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.client.snmp.SnmpTrapParameterMapping;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.snmp.Activator;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.dialogs.MibSelectionDialog;
import org.netxms.ui.eclipse.snmp.dialogs.ParamMappingEditDialog;
import org.netxms.ui.eclipse.snmp.dialogs.helpers.ParamMappingLabelProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class TrapConfigurationDialog
extends Dialog {
    private static final String PARAMLIST_TABLE_SETTINGS = "TrapConfigurationDialog.ParamList";
    private SnmpTrap trap;
    private List<SnmpTrapParameterMapping> pmap;
    private Text description;
    private Text oid;
    private EventSelector event;
    private Text eventTag;
    private TableViewer paramList;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonDelete;
    private Button buttonUp;
    private Button buttonDown;
    private Button buttonSelect;

    public TrapConfigurationDialog(Shell parentShell, SnmpTrap trap) {
        super(parentShell);
        this.trap = trap;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TrapConfigurationDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.description = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)Messages.TrapConfigurationDialog_Description, (String)this.trap.getDescription(), (Object)"WidgetHelper::default_layout_data");
        Composite oidSelection = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        oidSelection.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        oidSelection.setLayoutData((Object)gd);
        this.oid = WidgetHelper.createLabeledText((Composite)oidSelection, (int)2048, (int)300, (String)Messages.TrapConfigurationDialog_TrapOID, (String)(this.trap.getObjectId() != null ? this.trap.getObjectId().toString() : ""), (Object)"WidgetHelper::default_layout_data");
        this.buttonSelect = new Button(oidSelection, 8);
        this.buttonSelect.setText(Messages.TrapConfigurationDialog_Select);
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 1024;
        this.buttonSelect.setLayoutData((Object)gd);
        this.buttonSelect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TrapConfigurationDialog.this.selectObjectId();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.event = new EventSelector(dialogArea, 0);
        this.event.setLabel(Messages.TrapConfigurationDialog_Event);
        this.event.setEventCode((long)this.trap.getEventCode());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.event.setLayoutData((Object)gd);
        this.eventTag = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)-1, (String)Messages.TrapConfigurationDialog_UserTag, (String)this.trap.getUserTag(), (Object)"WidgetHelper::default_layout_data");
        Label label = new Label(dialogArea, 0);
        label.setText(Messages.TrapConfigurationDialog_Parameters);
        Composite paramArea = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        paramArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        paramArea.setLayout((Layout)layout);
        this.paramList = new TableViewer(paramArea, 67584);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 300;
        this.paramList.getTable().setLayoutData((Object)gd);
        this.setupParameterList();
        Composite buttonArea = new Composite(paramArea, 0);
        RowLayout btnLayout = new RowLayout();
        btnLayout.type = 512;
        btnLayout.marginBottom = 0;
        btnLayout.marginLeft = 0;
        btnLayout.marginRight = 0;
        btnLayout.marginTop = 0;
        btnLayout.fill = true;
        btnLayout.spacing = 4;
        buttonArea.setLayout((Layout)btnLayout);
        this.buttonAdd = new Button(buttonArea, 8);
        this.buttonAdd.setText(Messages.TrapConfigurationDialog_Add);
        this.buttonAdd.setLayoutData((Object)new RowData(90, -1));
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TrapConfigurationDialog.this.addParameter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.buttonEdit = new Button(buttonArea, 8);
        this.buttonEdit.setText(Messages.TrapConfigurationDialog_Edit);
        this.buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TrapConfigurationDialog.this.editParameter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.buttonDelete = new Button(buttonArea, 8);
        this.buttonDelete.setText(Messages.TrapConfigurationDialog_Delete);
        this.buttonDelete.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TrapConfigurationDialog.this.deleteParameters();
            }
        });
        this.buttonUp = new Button(buttonArea, 8);
        this.buttonUp.setText(Messages.TrapConfigurationDialog_MoveUp);
        this.buttonDown = new Button(buttonArea, 8);
        this.buttonDown.setText(Messages.TrapConfigurationDialog_MoveDown);
        return dialogArea;
    }

    private void selectObjectId() {
        SnmpObjectId id;
        try {
            id = SnmpObjectId.parseSnmpObjectId((String)this.oid.getText());
        }
        catch (SnmpObjectIdFormatException snmpObjectIdFormatException) {
            id = null;
        }
        MibSelectionDialog dlg = new MibSelectionDialog(this.getShell(), id, 0L);
        if (dlg.open() == 0) {
            this.oid.setText(dlg.getSelectedObjectId().toString());
            this.oid.setFocus();
        }
    }

    private void addParameter() {
        SnmpTrapParameterMapping pm = new SnmpTrapParameterMapping(new SnmpObjectId());
        ParamMappingEditDialog dlg = new ParamMappingEditDialog(this.getShell(), pm);
        if (dlg.open() == 0) {
            this.pmap.add(pm);
            this.paramList.setInput((Object)this.pmap.toArray());
            this.paramList.setSelection((ISelection)new StructuredSelection((Object)pm));
        }
    }

    private void editParameter() {
        IStructuredSelection selection = (IStructuredSelection)this.paramList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        SnmpTrapParameterMapping pm = (SnmpTrapParameterMapping)selection.getFirstElement();
        ParamMappingEditDialog dlg = new ParamMappingEditDialog(this.getShell(), pm);
        if (dlg.open() == 0) {
            this.paramList.update((Object)pm, null);
        }
    }

    private void deleteParameters() {
        IStructuredSelection selection = (IStructuredSelection)this.paramList.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.pmap.remove(it.next());
        }
        this.paramList.setInput((Object)this.pmap.toArray());
    }

    private void setupParameterList() {
        Table table = this.paramList.getTable();
        table.setHeaderVisible(true);
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText(Messages.TrapConfigurationDialog_Number);
        tc.setWidth(90);
        tc = new TableColumn(table, 16384);
        tc.setText(Messages.TrapConfigurationDialog_Parameter);
        tc.setWidth(200);
        this.pmap = new ArrayList<SnmpTrapParameterMapping>(this.trap.getParameterMapping());
        this.paramList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.paramList.setLabelProvider((IBaseLabelProvider)new ParamMappingLabelProvider(this.pmap));
        this.paramList.setInput((Object)this.pmap.toArray());
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)PARAMLIST_TABLE_SETTINGS);
        this.paramList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TrapConfigurationDialog.this.editParameter();
            }
        });
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.paramList.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)PARAMLIST_TABLE_SETTINGS);
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        try {
            this.trap.setObjectId(SnmpObjectId.parseSnmpObjectId((String)this.oid.getText()));
        }
        catch (SnmpObjectIdFormatException snmpObjectIdFormatException) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)Messages.TrapConfigurationDialog_Warning, (String)Messages.TrapConfigurationDialog_WarningInvalidOID);
            return;
        }
        this.trap.setDescription(this.description.getText());
        this.trap.setEventCode((int)this.event.getEventCode());
        this.trap.setUserTag(this.eventTag.getText());
        this.trap.getParameterMapping().clear();
        this.trap.getParameterMapping().addAll(this.pmap);
        this.saveSettings();
        super.okPressed();
    }
}

