/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.AlgorithmHelper;
import org.eclipse.zest.layouts.algorithms.TreeLayoutObserver;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.LayoutContext;

public class TreeLayoutAlgorithm
implements LayoutAlgorithm {
    public static final int TOP_DOWN = 1;
    public static final int BOTTOM_UP = 2;
    public static final int LEFT_RIGHT = 3;
    public static final int RIGHT_LEFT = 4;
    private int direction = 1;
    private boolean resize = false;
    private LayoutContext context;
    private DisplayIndependentRectangle bounds;
    private double leafSize;
    private double layerSize;
    private TreeLayoutObserver treeObserver;
    private Dimension nodeSpace;

    public TreeLayoutAlgorithm() {
    }

    public TreeLayoutAlgorithm(int direction) {
        this(direction, null);
    }

    public TreeLayoutAlgorithm(int direction, Dimension nodeSpace) {
        this.setDirection(direction);
        this.nodeSpace = nodeSpace;
    }

    public void setNodeSpace(Dimension nodeSpace) {
        this.nodeSpace = nodeSpace;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction != 1 && direction != 2 && direction != 3 && direction != 4) {
            throw new IllegalArgumentException("Invalid direction: " + direction);
        }
        this.direction = direction;
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
    }

    public void setLayoutContext(LayoutContext context) {
        if (this.treeObserver != null) {
            this.treeObserver.stop();
        }
        this.context = context;
        if (context != null) {
            this.treeObserver = new TreeLayoutObserver(context, null);
        }
    }

    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.internalApplyLayout();
        EntityLayout[] entities = this.context.getEntities();
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(entities);
        }
        this.scaleEntities(entities);
    }

    private void scaleEntities(EntityLayout[] entities) {
        if (this.nodeSpace == null) {
            DisplayIndependentRectangle bounds2 = new DisplayIndependentRectangle(this.bounds);
            int insets = 4;
            bounds2.x += (double)insets;
            bounds2.y += (double)insets;
            bounds2.width -= (double)(2 * insets);
            bounds2.height -= (double)(2 * insets);
            AlgorithmHelper.fitWithinBounds(entities, bounds2, this.resize);
        }
    }

    void internalApplyLayout() {
        TreeLayoutObserver.TreeNode superRoot = this.treeObserver.getSuperRoot();
        this.bounds = this.context.getBounds();
        this.updateLeafAndLayerSizes();
        int leafCountSoFar = 0;
        for (TreeLayoutObserver.TreeNode rootInfo : superRoot.getChildren()) {
            this.computePositionRecursively(rootInfo, leafCountSoFar);
            leafCountSoFar += rootInfo.numOfLeaves;
        }
    }

    private void updateLeafAndLayerSizes() {
        if (this.nodeSpace != null) {
            if (this.getDirection() == 1 || this.getDirection() == 2) {
                this.leafSize = this.nodeSpace.preciseWidth();
                this.layerSize = this.nodeSpace.preciseHeight();
            } else {
                this.leafSize = this.nodeSpace.preciseHeight();
                this.layerSize = this.nodeSpace.preciseWidth();
            }
        } else {
            TreeLayoutObserver.TreeNode superRoot = this.treeObserver.getSuperRoot();
            if (this.direction == 1 || this.direction == 2) {
                this.leafSize = this.bounds.width / (double)superRoot.numOfLeaves;
                this.layerSize = this.bounds.height / (double)superRoot.height;
            } else {
                this.leafSize = this.bounds.height / (double)superRoot.numOfLeaves;
                this.layerSize = this.bounds.width / (double)superRoot.height;
            }
        }
    }

    private void computePositionRecursively(TreeLayoutObserver.TreeNode entityInfo, int relativePosition) {
        double breadthPosition = (double)relativePosition + (double)entityInfo.numOfLeaves / 2.0;
        double depthPosition = (double)entityInfo.depth + 0.5;
        switch (this.direction) {
            case 1: {
                entityInfo.getNode().setLocation(breadthPosition * this.leafSize, depthPosition * this.layerSize);
                break;
            }
            case 2: {
                entityInfo.getNode().setLocation(breadthPosition * this.leafSize, this.bounds.height - depthPosition * this.layerSize);
                break;
            }
            case 3: {
                entityInfo.getNode().setLocation(depthPosition * this.layerSize, breadthPosition * this.leafSize);
                break;
            }
            case 4: {
                entityInfo.getNode().setLocation(this.bounds.width - depthPosition * this.layerSize, breadthPosition * this.leafSize);
            }
        }
        for (TreeLayoutObserver.TreeNode childInfo : entityInfo.children) {
            this.computePositionRecursively(childInfo, relativePosition);
            relativePosition += childInfo.numOfLeaves;
        }
    }
}

