/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;

public class ZestRootLayer
extends FreeformLayer {
    public static final int CONNECTIONS_LAYER = 0;
    public static final int SUBGRAPHS_LAYER = 1;
    public static final int NODES_LAYER = 2;
    public static final int CONNECTIONS_HIGHLIGHTED_LAYER = 3;
    public static final int NODES_HIGHLIGHTED_LAYER = 4;
    public static final int TOP_LAYER = 5;
    public static final int NUMBER_OF_LAYERS = 6;
    private final int[] itemsInLayer = new int[6];
    private HashSet decoratingFigures = new HashSet();
    private boolean isLayerKnown = false;

    public void addNode(IFigure nodeFigure) {
        this.addFigure(nodeFigure, 2);
    }

    public void addConnection(IFigure connectionFigure) {
        this.addFigure(connectionFigure, 0);
    }

    public void addSubgraph(IFigure subgraphFigrue) {
        this.addFigure(subgraphFigrue, 1);
    }

    public void highlightNode(IFigure nodeFigure) {
        this.changeFigureLayer(nodeFigure, 4);
    }

    public void highlightConnection(IFigure connectionFigure) {
        this.changeFigureLayer(connectionFigure, 3);
    }

    public void unHighlightNode(IFigure nodeFigure) {
        this.changeFigureLayer(nodeFigure, 2);
    }

    public void unHighlightConnection(IFigure connectionFigure) {
        this.changeFigureLayer(connectionFigure, 0);
    }

    private void changeFigureLayer(IFigure figure, int newLayer) {
        ArrayList decorations = this.getDecorations(figure);
        this.remove(figure);
        this.addFigure(figure, newLayer);
        Iterator iterator = decorations.iterator();
        while (iterator.hasNext()) {
            this.addDecoration(figure, (IFigure)iterator.next());
        }
        this.invalidate();
        this.repaint();
    }

    private ArrayList getDecorations(IFigure figure) {
        ArrayList result = new ArrayList();
        int index = this.getChildren().indexOf(figure);
        if (index == -1) {
            return result;
        }
        ++index;
        while (index < this.getChildren().size()) {
            Object nextFigure = this.getChildren().get(index);
            if (!this.decoratingFigures.contains(nextFigure)) break;
            result.add(nextFigure);
            ++index;
        }
        return result;
    }

    private int getPosition(int layer) {
        int result = 0;
        int i = 0;
        while (i <= layer) {
            result += this.itemsInLayer[i];
            ++i;
        }
        return result;
    }

    private int getLayer(int position) {
        int layer = 0;
        int positionInLayer = this.itemsInLayer[0];
        while (layer < 5 && positionInLayer <= position) {
            positionInLayer += this.itemsInLayer[++layer];
        }
        return layer;
    }

    public void addFigure(IFigure figure, int layer) {
        int position = this.getPosition(layer);
        int n = layer;
        this.itemsInLayer[n] = this.itemsInLayer[n] + 1;
        this.isLayerKnown = true;
        this.add(figure, position);
    }

    public void add(IFigure child, Object constraint, int index) {
        super.add(child, constraint, index);
        if (!this.isLayerKnown) {
            int layer = 0;
            int positionInLayer = this.itemsInLayer[0];
            while (positionInLayer < index) {
                positionInLayer += this.itemsInLayer[++layer];
            }
            if (index == -1) {
                layer = 5;
            }
            int n = layer;
            this.itemsInLayer[n] = this.itemsInLayer[n] + 1;
        }
        this.isLayerKnown = false;
    }

    public void remove(IFigure child) {
        int position = this.getChildren().indexOf(child);
        if (position == -1) {
            return;
        }
        int n = this.getLayer(position);
        this.itemsInLayer[n] = this.itemsInLayer[n] - 1;
        if (this.decoratingFigures.contains(child)) {
            this.decoratingFigures.remove(child);
            super.remove(child);
        } else {
            ArrayList decorations = this.getDecorations(child);
            super.remove(child);
            Iterator iterator = decorations.iterator();
            while (iterator.hasNext()) {
                this.remove((IFigure)iterator.next());
            }
        }
    }

    public void addDecoration(IFigure decorated, IFigure decorating) {
        int position = this.getChildren().indexOf(decorated);
        if (position == -1) {
            throw new RuntimeException("Can't add decoration for a figuer that is not on this ZestRootLayer");
        }
        int n = this.getLayer(position);
        this.itemsInLayer[n] = this.itemsInLayer[n] + 1;
        this.isLayerKnown = true;
        while (++position < this.getChildren().size() && this.decoratingFigures.contains(this.getChildren().get(position))) {
        }
        this.decoratingFigures.add(decorating);
        this.add(decorating, position);
    }
}

