/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.zest.core.viewers.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.internal.GraphModelEntityRelationshipFactory;
import org.eclipse.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.custom.CGraphNode;
import org.eclipse.zest.core.widgets.zooming.ZoomManager;
import org.netxms.base.GeoLocation;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.helpers.DecorationFigure;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapContentProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigure;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ZoomAction;
import org.netxms.ui.eclipse.osm.tools.MapLoader;
import org.netxms.ui.eclipse.osm.tools.Tile;
import org.netxms.ui.eclipse.osm.tools.TileSet;
import org.netxms.ui.eclipse.tools.ColorCache;

public class ExtendedGraphViewer
extends GraphViewer {
    private static final double[] zoomLevels = new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.5, 3.0, 4.0};
    private BackgroundFigure backgroundFigure;
    private Image backgroundImage = null;
    private GeoLocation backgroundLocation = null;
    private int backgroundZoom;
    private IFigure zestRootLayer;
    private MapLoader mapLoader;
    private Layer backgroundLayer;
    private Layer decorationLayer;
    private Layer indicatorLayer;
    private int crosshairX;
    private int crosshairY;
    private Crosshair crosshairFigure;
    private GridFigure gridFigure;
    private int gridSize = 96;
    private boolean snapToGrid = false;
    private MouseListener snapToGridListener;
    private List<NetworkMapDecoration> mapDecorations;
    private Set<NetworkMapDecoration> selectedDecorations = new HashSet<NetworkMapDecoration>();
    private Map<Long, DecorationFigure> decorationFigures = new HashMap<Long, DecorationFigure>();
    private MouseListener backgroundMouseListener;
    private ColorCache colors = new ColorCache((Control)this.graph);

    public ExtendedGraphViewer(Composite composite, int style) {
        super(composite, style);
        ScalableFigure rootLayer = this.graph.getRootLayer();
        this.mapLoader = new MapLoader(composite.getDisplay());
        this.graph.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExtendedGraphViewer.this.mapLoader.dispose();
            }
        });
        this.backgroundLayer = new FreeformLayer();
        rootLayer.add((IFigure)this.backgroundLayer, null, 0);
        this.backgroundFigure = new BackgroundFigure();
        this.backgroundFigure.setSize(10, 10);
        this.backgroundLayer.add((IFigure)this.backgroundFigure);
        this.decorationLayer = new FreeformLayer();
        rootLayer.add((IFigure)this.decorationLayer, null, 1);
        this.indicatorLayer = new FreeformLayer();
        rootLayer.add((IFigure)this.indicatorLayer, null, 2);
        this.getZoomManager().setZoomLevels(zoomLevels);
        for (Object f : rootLayer.getChildren()) {
            if (!f.getClass().getName().equals("org.eclipse.zest.core.widgets.internal.ZestRootLayer")) continue;
            this.zestRootLayer = (IFigure)f;
        }
        final Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (ExtendedGraphViewer.this.graph.isDisposed()) {
                    return;
                }
                if (ExtendedGraphViewer.this.backgroundLocation != null) {
                    ExtendedGraphViewer.this.reloadMapBackground();
                }
                if (ExtendedGraphViewer.this.gridFigure != null) {
                    ExtendedGraphViewer.this.gridFigure.setSize(ExtendedGraphViewer.this.graph.getRootLayer().getSize());
                }
            }
        };
        this.zestRootLayer.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                ExtendedGraphViewer.this.graph.getDisplay().timerExec(-1, timer);
                ExtendedGraphViewer.this.graph.getDisplay().timerExec(1000, timer);
            }
        });
        this.backgroundMouseListener = new MouseListener(){

            public void mouseReleased(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
                ExtendedGraphViewer.this.clearDecorationSelection(true);
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        };
        this.backgroundFigure.addMouseListener(this.backgroundMouseListener);
        this.graph.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedGraphViewer.this.clearDecorationSelection(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.graph.getLightweightSystem().getRootFigure().addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
                Point mousePoint = new Point(me.x, me.y);
                ExtendedGraphViewer.this.graph.getRootLayer().translateToRelative((Translatable)mousePoint);
                IFigure figureUnderMouse = ExtendedGraphViewer.this.graph.getFigureAt(mousePoint.x, mousePoint.y);
                if (figureUnderMouse == null || figureUnderMouse == ExtendedGraphViewer.this.graph) {
                    if ((me.getState() & SWT.MOD1) == 0) {
                        ExtendedGraphViewer.this.clearDecorationSelection(true);
                    }
                    return;
                }
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
        this.snapToGridListener = new MouseListener(){

            public void mouseReleased(MouseEvent me) {
                if (ExtendedGraphViewer.this.snapToGrid && ExtendedGraphViewer.this.graph.getRootLayer().findFigureAt(me.x, me.y) != null) {
                    ExtendedGraphViewer.this.alignToGrid(true);
                }
            }

            public void mousePressed(MouseEvent me) {
                for (Object o : ExtendedGraphViewer.this.graph.getNodes()) {
                    if (!(o instanceof CGraphNode)) continue;
                    CGraphNode n = (CGraphNode)o;
                    ((ObjectFigure)n.getFigure()).readMovedState();
                }
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        };
    }

    public void updateDecorationFigure(NetworkMapDecoration d) {
        DecorationFigure figure = this.decorationFigures.get(d.getId());
        if (figure != null) {
            figure.refresh();
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        boolean dynamicLayoutEnabled = this.graph.isDynamicLayoutEnabled();
        this.graph.setDynamicLayout(false);
        super.inputChanged(input, oldInput);
        this.graph.setDynamicLayout(dynamicLayoutEnabled);
        this.decorationLayer.removeAll();
        this.decorationFigures.clear();
        if (this.getContentProvider() instanceof MapContentProvider && this.getLabelProvider() instanceof MapLabelProvider) {
            this.mapDecorations = ((MapContentProvider)this.getContentProvider()).getDecorations(input);
            if (this.mapDecorations != null) {
                MapLabelProvider lp = (MapLabelProvider)this.getLabelProvider();
                for (NetworkMapDecoration d : this.mapDecorations) {
                    DecorationFigure figure = (DecorationFigure)lp.getFigure(d);
                    figure.setLocation(new Point(d.getX(), d.getY()));
                    this.decorationLayer.add((IFigure)figure);
                    this.decorationFigures.put(d.getId(), figure);
                }
            }
        }
    }

    protected void setDecorationSelection(NetworkMapDecoration d, boolean addToExisting) {
        if (!addToExisting) {
            this.clearDecorationSelection(false);
            this.graph.setSelection(null);
        }
        this.selectedDecorations.add(d);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(event);
        this.firePostSelectionChanged(event);
    }

    private void clearDecorationSelection(boolean sendEvent) {
        if (this.selectedDecorations.size() == 0) {
            return;
        }
        for (NetworkMapDecoration d : this.selectedDecorations) {
            DecorationFigure f = this.decorationFigures.get(d.getId());
            if (f == null) continue;
            f.setSelected(false);
        }
        this.selectedDecorations.clear();
        if (sendEvent) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            this.fireSelectionChanged(event);
            this.firePostSelectionChanged(event);
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        this.selectedDecorations.clear();
        if (l != null) {
            this.clearDecorationSelection(false);
            for (Object o : l) {
                if (!(o instanceof NetworkMapDecoration)) continue;
                this.selectedDecorations.add((NetworkMapDecoration)o);
                DecorationFigure f = this.decorationFigures.get(((NetworkMapDecoration)o).getId());
                if (f == null) continue;
                f.setSelected(true);
            }
        }
        super.setSelectionToWidget(l, reveal);
    }

    protected List getSelectionFromWidget() {
        List selection = super.getSelectionFromWidget();
        for (NetworkMapDecoration d : this.selectedDecorations) {
            selection.add(d);
        }
        return selection;
    }

    public void setBackgroundColor(RGB color) {
        Color c = this.colors.create(color);
        this.graph.setBackground(c);
        this.graph.getLightweightSystem().getRootFigure().setBackgroundColor(c);
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        if (image != null) {
            org.eclipse.swt.graphics.Rectangle r = image.getBounds();
            this.backgroundFigure.setSize(r.width, r.height);
        } else {
            this.backgroundFigure.setSize(10, 10);
        }
        this.backgroundLocation = null;
        this.graph.redraw();
    }

    public void setBackgroundImage(GeoLocation location, int zoom) {
        if (this.backgroundLocation != null && this.backgroundImage != null) {
            this.backgroundImage.dispose();
        }
        this.backgroundImage = null;
        this.backgroundLocation = location;
        this.backgroundZoom = zoom;
        this.backgroundFigure.setSize(10, 10);
        this.graph.redraw();
        this.reloadMapBackground();
    }

    private void reloadMapBackground() {
        org.eclipse.swt.graphics.Rectangle controlSize = this.graph.getClientArea();
        Rectangle rootLayerSize = this.zestRootLayer.getClientArea();
        final org.eclipse.swt.graphics.Point mapSize = new org.eclipse.swt.graphics.Point(Math.min(controlSize.width, rootLayerSize.width), Math.max(controlSize.height, rootLayerSize.height));
        ConsoleJob job = new ConsoleJob(Messages.ExtendedGraphViewer_DownloadTilesJob, null, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final TileSet tiles = ExtendedGraphViewer.this.mapLoader.getAllTiles(mapSize, ExtendedGraphViewer.this.backgroundLocation, 1, ExtendedGraphViewer.this.backgroundZoom, false);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ExtendedGraphViewer.this.backgroundLocation == null || ExtendedGraphViewer.this.graph.isDisposed()) {
                            return;
                        }
                        ExtendedGraphViewer.this.backgroundFigure.setSize(mapSize.x, mapSize.y);
                        ExtendedGraphViewer.this.drawTiles(tiles);
                        ExtendedGraphViewer.this.graph.redraw();
                    }
                });
            }

            protected String getErrorMessage() {
                return Messages.ExtendedGraphViewer_DownloadTilesError;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void drawTiles(TileSet tileSet) {
        if (this.backgroundLocation != null && this.backgroundImage != null) {
            this.backgroundImage.dispose();
        }
        if (tileSet == null || tileSet.tiles == null || tileSet.tiles.length == 0) {
            this.backgroundImage = null;
            return;
        }
        Tile[][] tiles = tileSet.tiles;
        Dimension size = this.backgroundFigure.getSize();
        this.backgroundImage = new Image((Device)this.graph.getDisplay(), size.width, size.height);
        GC gc = new GC((Drawable)this.backgroundImage);
        int x = tileSet.xOffset;
        int y = tileSet.yOffset;
        int i = 0;
        while (i < tiles.length) {
            int j = 0;
            while (j < tiles[i].length) {
                gc.drawImage(tiles[i][j].getImage(), x, y);
                if ((x += 256) >= size.width) {
                    x = tileSet.xOffset;
                    y += 256;
                }
                ++j;
            }
            ++i;
        }
        gc.dispose();
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        if (this.getInput() == null) {
            return;
        }
        if (element == this.getInput()) {
            this.getFactory().refreshGraph(this.graph);
        } else {
            this.getFactory().refresh(this.graph, element, updateLabels);
        }
    }

    public void zoomIn() {
        this.getZoomManager().zoomIn();
    }

    public void zoomOut() {
        this.getZoomManager().zoomOut();
    }

    public void zoomTo(double zoomLevel) {
        this.getZoomManager().setZoom(zoomLevel);
    }

    public Action[] createZoomActions() {
        ZoomManager zoomManager = this.getZoomManager();
        Action[] actions = new Action[zoomLevels.length];
        int i = 0;
        while (i < zoomLevels.length) {
            actions[i] = new ZoomAction(zoomLevels[i], zoomManager);
            if (zoomLevels[i] == 1.0) {
                actions[i].setChecked(true);
            }
            ++i;
        }
        return actions;
    }

    public void showCrosshair(int x, int y) {
        if (this.crosshairFigure == null) {
            this.crosshairFigure = new Crosshair();
            this.indicatorLayer.add((IFigure)this.crosshairFigure);
            this.crosshairFigure.setSize(this.graph.getRootLayer().getSize());
        }
        this.crosshairX = x;
        this.crosshairY = y;
        this.crosshairFigure.repaint();
    }

    public void hideCrosshair() {
        if (this.crosshairFigure != null) {
            this.indicatorLayer.remove((IFigure)this.crosshairFigure);
            this.crosshairFigure = null;
        }
    }

    public void showGrid(boolean show) {
        if (show) {
            if (this.gridFigure == null) {
                this.gridFigure = new GridFigure();
                this.backgroundLayer.add((IFigure)this.gridFigure, null, 1);
                this.gridFigure.setSize(this.graph.getRootLayer().getSize());
            }
        } else if (this.gridFigure != null) {
            this.backgroundLayer.remove((IFigure)this.gridFigure);
            this.gridFigure = null;
        }
    }

    public boolean isGridVisible() {
        return this.gridFigure != null;
    }

    public void alignToGrid(boolean movedOnly) {
        for (Object o : this.graph.getNodes()) {
            ObjectFigure f;
            if (!(o instanceof CGraphNode)) continue;
            CGraphNode n = (CGraphNode)o;
            if (movedOnly && (!(f = (ObjectFigure)n.getFigure()).readMovedState() || !f.isElementSelected())) continue;
            Point p = n.getLocation();
            Dimension size = n.getSize();
            int dx = p.x % this.gridSize;
            dx = dx < this.gridSize / 2 ? -dx : this.gridSize - dx;
            int dy = p.y % this.gridSize;
            dy = dy < this.gridSize / 2 ? -dy : this.gridSize - dy;
            n.setLocation((double)(p.x + (dx += (this.gridSize - size.width) / 2)), (double)(p.y + (dy += (this.gridSize - size.height) / 2)));
        }
    }

    public void setSnapToGrid(boolean snap) {
        if (snap == this.snapToGrid) {
            return;
        }
        this.snapToGrid = snap;
        if (snap) {
            this.graph.getLightweightSystem().getRootFigure().addMouseListener(this.snapToGridListener);
        } else {
            this.graph.getLightweightSystem().getRootFigure().removeMouseListener(this.snapToGridListener);
        }
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    protected IStylingGraphModelFactory getFactory() {
        return new GraphModelEntityRelationshipFactory((AbstractStructuredGraphViewer)this){

            public void styleConnection(GraphConnection conn) {
            }
        };
    }

    private class BackgroundFigure
    extends Figure {
        private BackgroundFigure() {
        }

        protected void paintFigure(Graphics gc) {
            if (ExtendedGraphViewer.this.backgroundImage != null) {
                gc.drawImage(ExtendedGraphViewer.this.backgroundImage, 0, 0);
            }
        }
    }

    private class Crosshair
    extends Figure {
        public Crosshair() {
            this.setOpaque(false);
        }

        protected void paintFigure(Graphics gc) {
            gc.setLineStyle(3);
            Dimension size = this.getSize();
            gc.drawLine(0, ExtendedGraphViewer.this.crosshairY, size.width, ExtendedGraphViewer.this.crosshairY);
            gc.drawLine(ExtendedGraphViewer.this.crosshairX, 0, ExtendedGraphViewer.this.crosshairX, size.height);
        }
    }

    private class GridFigure
    extends Figure {
        public GridFigure() {
            this.setOpaque(false);
            this.addMouseListener(ExtendedGraphViewer.this.backgroundMouseListener);
        }

        protected void paintFigure(Graphics gc) {
            gc.setLineStyle(3);
            Dimension size = this.getSize();
            int x = ExtendedGraphViewer.this.gridSize;
            while (x < size.width) {
                gc.drawLine(x, 0, x, size.height);
                x += ExtendedGraphViewer.this.gridSize;
            }
            int y = ExtendedGraphViewer.this.gridSize;
            while (y < size.height) {
                gc.drawLine(0, y, size.width, y);
                y += ExtendedGraphViewer.this.gridSize;
            }
        }
    }
}

