/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.dialogs.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.dashboard.Activator;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.DciIdMatchingData;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.IdMatchingData;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.objectbrowser.shared.ObjectIcons;
import org.netxms.ui.eclipse.tools.ImageCache;

public class IdMatchingLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private ImageCache imageCache = new ImageCache();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        if (element instanceof ObjectIdMatchingData) {
            return this.imageCache.add(ObjectIcons.getObjectImageDescriptor((int)((ObjectIdMatchingData)element).objectClass));
        }
        if (element instanceof DciIdMatchingData) {
            return this.imageCache.add(Activator.getImageDescriptor("icons/dci.png"));
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.toString(((IdMatchingData)element).getSourceId());
            }
            case 1: {
                return ((IdMatchingData)element).getSourceName();
            }
            case 2: {
                long id = ((IdMatchingData)element).getDestinationId();
                return id > 0L ? Long.toString(id) : Messages.IdMatchingLabelProvider_NoMatch;
            }
            case 3: {
                return ((IdMatchingData)element).getDestinationName();
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        return SharedColors.getColor((String)(((IdMatchingData)element).getDestinationId() != 0L ? "Text.Normal" : "Text.Error"), (Display)Display.getCurrent());
    }

    public Color getBackground(Object element) {
        return null;
    }

    public void dispose() {
        this.imageCache.dispose();
        super.dispose();
    }
}

