/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LineDecorator implements Enumerator
{
    ARROW_LITERAL(0, "Arrow", "Arrow"),
    CIRCLE_LITERAL(1, "Circle", "Circle"),
    NONE_LITERAL(2, "None", "None");

    public static final int ARROW = 0;
    public static final int CIRCLE = 1;
    public static final int NONE = 2;
    private static final LineDecorator[] VALUES_ARRAY;
    public static final List<LineDecorator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LineDecorator[]{ARROW_LITERAL, CIRCLE_LITERAL, NONE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LineDecorator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineDecorator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineDecorator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineDecorator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineDecorator get(int value) {
        switch (value) {
            case 0: {
                return ARROW_LITERAL;
            }
            case 1: {
                return CIRCLE_LITERAL;
            }
            case 2: {
                return NONE_LITERAL;
            }
        }
        return null;
    }

    private LineDecorator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

