/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigure;

public class ObjectFigureIcon
extends ObjectFigure {
    private static final int IMAGE_MARGIN_Y = 4;
    private static final int BACKGROUND_MARGIN_X = 4;
    private static final int BACKGROUND_MARGIN_Y = 4;
    private static final int FRAME_LINE_WIDTH = 3;
    private Label label;
    private int imageWidth;
    private int imageHeight;

    public ObjectFigureIcon(NetworkMapObject element, MapLabelProvider labelProvider) {
        super(element, labelProvider);
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.label = new Label(this.object.getObjectName());
        this.label.setFont(labelProvider.getLabelFont());
        this.label.setLabelAlignment(2);
        this.add((IFigure)this.label, BorderLayout.BOTTOM);
        this.setOpaque(false);
        this.updateSize();
    }

    private void updateSize() {
        Image image = this.labelProvider.getImage(this.element);
        if (image != null) {
            this.imageWidth = image.getImageData().width;
            this.imageHeight = image.getImageData().height;
        } else {
            this.imageWidth = 32;
            this.imageHeight = 32;
        }
        Dimension ls = this.label.getPreferredSize(-1, -1);
        if (ls.width > this.imageWidth * 2) {
            ls.width = this.imageWidth * 2;
        }
        this.setSize(Math.max(Math.max(ls.width, this.imageWidth), this.imageWidth + 8 + 3), this.imageHeight + 8 + ls.height);
    }

    protected void paintFigure(Graphics gc) {
        gc.setAntialias(1);
        org.eclipse.draw2d.geometry.Rectangle rect = new org.eclipse.draw2d.geometry.Rectangle(this.getBounds());
        int imageOffset = (rect.width - this.imageWidth) / 2;
        if (this.labelProvider.isShowStatusBackground()) {
            rect.x += imageOffset - 4;
            rect.y += 0;
            rect.width = this.imageWidth + 8;
            rect.height = this.imageWidth + 8;
            gc.setBackgroundColor(StatusDisplayInfo.getStatusColor((int)this.object.getStatus()));
            gc.setAlpha(64);
            gc.fillRoundRectangle(rect, 16, 16);
            gc.setAlpha(255);
            rect = new org.eclipse.draw2d.geometry.Rectangle(this.getBounds());
        }
        if (this.labelProvider.isShowStatusFrame()) {
            rect.x += imageOffset - 4;
            ++rect.y;
            rect.width = this.imageWidth + 8;
            rect.height = this.imageWidth + 8 - 1;
            gc.setForegroundColor(StatusDisplayInfo.getStatusColor((int)this.object.getStatus()));
            gc.setLineWidth(3);
            gc.setLineStyle(this.labelProvider.isElementSelected((NetworkMapElement)this.element) ? 3 : 1);
            gc.drawRoundRectangle(rect, 16, 16);
            rect = new org.eclipse.draw2d.geometry.Rectangle(this.getBounds());
        } else if (this.isElementSelected()) {
            rect.x += imageOffset - 4;
            ++rect.y;
            rect.width = this.imageWidth + 8;
            rect.height = this.imageWidth + 8 - 1;
            gc.setForegroundColor(SELECTION_COLOR);
            gc.setLineWidth(3);
            gc.setLineStyle(this.labelProvider.isElementSelected((NetworkMapElement)this.element) ? 3 : 1);
            gc.drawRoundRectangle(rect, 16, 16);
            rect = new org.eclipse.draw2d.geometry.Rectangle(this.getBounds());
        }
        Image image = this.labelProvider.getImage(this.element);
        if (image != null) {
            gc.drawImage(image, rect.x + imageOffset, rect.y + 4);
        }
        if (this.labelProvider.isShowStatusIcons() && (image = this.labelProvider.getStatusImage(this.object)) != null) {
            rect.x += imageOffset - 4;
            rect.width = this.imageWidth + 8;
            Rectangle imgSize = image.getBounds();
            gc.drawImage(image, rect.x + rect.width - imgSize.width, rect.y);
        }
    }

    @Override
    protected void onObjectUpdate() {
        this.label.setText(this.object.getObjectName());
        this.updateSize();
    }
}

