/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.dialogs.AttributeEditDialog;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.AttrListLabelProvider;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.AttrViewerComparator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class CustomAttributes
extends PropertyPage {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    private AbstractObject object = null;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Map<String, String> attributes = null;
    private boolean isModified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{"Name", "Value"};
        int[] columnWidths = new int[]{150, 250};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AttrListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new AttrViewerComparator());
        this.attributes = new HashMap<String, String>(this.object.getCustomAttributes());
        this.viewer.setInput(this.attributes.entrySet());
        if (!Platform.getPreferencesService().getBoolean("org.netxms.ui.eclipse.console", "SHOW_HIDDEN_ATTRIBUTES", false, null)) {
            this.viewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !((String)((Map.Entry)element).getKey()).startsWith(".");
                }
            });
        }
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("&Add...");
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AttributeEditDialog dlg = new AttributeEditDialog(CustomAttributes.this.getShell(), null, null);
                if (dlg.open() == 0) {
                    if (CustomAttributes.this.attributes.containsKey(dlg.getAttrName())) {
                        MessageDialogHelper.openWarning((Shell)CustomAttributes.this.getShell(), (String)"Warning", (String)("Attribute named " + dlg.getAttrName() + " already exists"));
                    } else {
                        CustomAttributes.this.attributes.put(dlg.getAttrName(), dlg.getAttrValue());
                        CustomAttributes.this.viewer.setInput(CustomAttributes.this.attributes.entrySet());
                        CustomAttributes.this.isModified = true;
                    }
                }
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText("&Modify...");
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CustomAttributes.this.viewer.getSelection();
                if (selection.size() == 1) {
                    Map.Entry element = (Map.Entry)selection.getFirstElement();
                    AttributeEditDialog dlg = new AttributeEditDialog(CustomAttributes.this.getShell(), (String)element.getKey(), (String)element.getValue());
                    if (dlg.open() == 0) {
                        CustomAttributes.this.attributes.put(dlg.getAttrName(), dlg.getAttrValue());
                        CustomAttributes.this.viewer.setInput(CustomAttributes.this.attributes.entrySet());
                        CustomAttributes.this.isModified = true;
                    }
                }
            }
        });
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText("&Delete");
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CustomAttributes.this.viewer.getSelection();
                Iterator it = selection.iterator();
                if (it.hasNext()) {
                    while (it.hasNext()) {
                        Map.Entry element = (Map.Entry)it.next();
                        CustomAttributes.this.attributes.remove(element.getKey());
                    }
                    CustomAttributes.this.viewer.setInput(CustomAttributes.this.attributes.entrySet());
                    CustomAttributes.this.isModified = true;
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CustomAttributes.this.editButton.notifyListeners(13, new Event());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CustomAttributes.this.viewer.getSelection();
                CustomAttributes.this.editButton.setEnabled(selection.size() == 1);
                CustomAttributes.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.isModified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setCustomAttributes(this.attributes);
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update custom attributes", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                CustomAttributes.this.isModified = false;
            }

            protected String getErrorMessage() {
                return "Cannot update object's custom attributes";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            CustomAttributes.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

