/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.objecttabs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.widgets.DeviceView;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortInfo;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortSelectionListener;

public class Ports
extends ObjectTab
implements ISelectionProvider {
    private ScrolledComposite scroller;
    private DeviceView deviceView;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private NXCSession session;

    protected void createTabContent(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.scroller = new ScrolledComposite(parent, 768);
        this.deviceView = new DeviceView((Composite)this.scroller, 0);
        this.deviceView.addSelectionListener(new PortSelectionListener(){

            @Override
            public void portSelected(PortInfo port) {
                if (port != null) {
                    Interface iface = (Interface)Ports.this.session.findObjectById(port.getInterfaceObjectId(), Interface.class);
                    if (iface != null) {
                        Ports.this.selection = (ISelection)new StructuredSelection((Object)iface);
                    } else {
                        Ports.this.selection = (ISelection)new StructuredSelection();
                    }
                } else {
                    Ports.this.selection = (ISelection)new StructuredSelection();
                }
                for (ISelectionChangedListener listener : Ports.this.selectionListeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)Ports.this, Ports.this.selection));
                }
            }
        });
        this.scroller.setContent((Control)this.deviceView);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.scroller.getHorizontalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Ports.this.scroller.setMinSize(Ports.this.deviceView.computeSize(-1, -1));
            }
        });
        this.createPopupMenu();
    }

    public void objectChanged(AbstractObject object) {
        this.deviceView.setNodeId(object != null ? object.getObjectId() : 0L);
        this.scroller.setMinSize(this.deviceView.computeSize(-1, -1));
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof Node && (((Node)object).getFlags() & 4) != 0;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Ports.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.deviceView);
        this.deviceView.setMenu(menu);
        this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("objectcreation"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectmgmt"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectbinding"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("topology"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("datacollection"));
        if (this.selection instanceof IStructuredSelection && ((IStructuredSelection)this.selection).size() == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new GroupMarker("properties"));
            manager.add((IAction)new PropertyDialogAction((IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this));
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

