/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.views.helpers.WirelessStationComparator;
import org.netxms.ui.eclipse.topology.views.helpers.WirelessStationLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class WirelessStations
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.topology.views.WirelessStations";
    public static final int COLUMN_MAC_ADDRESS = 0;
    public static final int COLUMN_IP_ADDRESS = 1;
    public static final int COLUMN_NODE_NAME = 2;
    public static final int COLUMN_ACCESS_POINT = 3;
    public static final int COLUMN_RADIO = 4;
    public static final int COLUMN_SSID = 5;
    private NXCSession session;
    private long rootObject;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionCopy;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.rootObject = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException numberFormatException) {
            this.rootObject = 0L;
        }
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.setPartName("Wireless Stations - " + this.session.getObjectName(this.rootObject));
    }

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"MAC Address", "IP Address", "Node", "AP", "Radio", "SSID"};
        int[] widths = new int[]{120, 90, 180, 180, 100, 100};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WirelessStationLabelProvider());
        this.viewer.setComparator((ViewerComparator)new WirelessStationComparator());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"WirelessStations");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)WirelessStations.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"WirelessStations");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                WirelessStations.this.refresh();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                WirelessStations.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void refresh() {
        new ConsoleJob("Get list of wireless stations", (IWorkbenchPart)this, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List stations = WirelessStations.this.session.getWirelessStations(WirelessStations.this.rootObject);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        WirelessStations.this.viewer.setInput((Object)stations.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of wireless stations";
            }
        }.start();
    }
}

