/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.widgets.helpers.SoftwareInventoryContentProvider;
import org.netxms.ui.eclipse.objectview.widgets.helpers.SoftwareInventoryNode;
import org.netxms.ui.eclipse.objectview.widgets.helpers.SoftwarePackageComparator;
import org.netxms.ui.eclipse.objectview.widgets.helpers.SoftwarePackageLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class SoftwareInventory
extends Composite {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VERSION = 1;
    public static final int COLUMN_VENDOR = 2;
    public static final int COLUMN_DATE = 3;
    public static final int COLUMN_DESCRIPTION = 4;
    public static final int COLUMN_URL = 5;
    private static final String[] names = new String[]{"Name", "Version", "Vendor", "Install Date", "Description", "URL"};
    private static final int[] widths = new int[]{200, 100, 200, 100, 300, 200};
    private IViewPart viewPart;
    private long rootObjectId;
    private ColumnViewer viewer;
    private String configPrefix;
    private MenuManager menuManager = null;

    public SoftwareInventory(Composite parent, int style, IViewPart viewPart, String configPrefix) {
        super(parent, style);
        this.viewPart = viewPart;
        this.configPrefix = configPrefix;
        this.setLayout((Layout)new FillLayout());
        this.createTableViewer();
    }

    private void createTableViewer() {
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 0, 128, 65538);
        WidgetHelper.restoreColumnViewerSettings((ColumnViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)this.configPrefix);
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnViewerSettings((ColumnViewer)SoftwareInventory.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)SoftwareInventory.this.configPrefix);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(false));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this.viewer);
        }
    }

    private void createTreeViewer() {
        this.viewer = new SortableTreeViewer((Composite)this, names, widths, 0, 128, 65538);
        WidgetHelper.restoreColumnViewerSettings((ColumnViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)this.configPrefix);
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnViewerSettings((ColumnViewer)SoftwareInventory.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)SoftwareInventory.this.configPrefix);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new SoftwareInventoryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(true));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this.viewer);
        }
    }

    public void refresh() {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Read software package information", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AbstractObject object = session.findObjectById(SoftwareInventory.this.rootObjectId);
                if (object instanceof AbstractNode) {
                    final List packages = session.getNodeSoftwarePackages(SoftwareInventory.this.rootObjectId);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SoftwareInventory.this.viewer.setInput((Object)packages.toArray());
                        }
                    });
                } else {
                    final ArrayList<SoftwareInventoryNode> nodes = new ArrayList<SoftwareInventoryNode>();
                    for (AbstractObject o : object.getAllChilds(2)) {
                        try {
                            List packages = session.getNodeSoftwarePackages(o.getObjectId());
                            nodes.add(new SoftwareInventoryNode((Node)o, packages));
                        }
                        catch (NXCException e) {
                            if (e.getErrorCode() == 100) continue;
                            throw e;
                        }
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SoftwareInventory.this.viewer.setInput((Object)nodes);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot get software package information for node";
            }
        }.start();
    }

    public long getRootObjectId() {
        return this.rootObjectId;
    }

    public void setRootObjectId(long rootObjectId) {
        this.rootObjectId = rootObjectId;
        AbstractObject object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(rootObjectId);
        if (object instanceof Node) {
            if (!(this.viewer instanceof SortableTableViewer)) {
                this.viewer.getControl().dispose();
                this.createTableViewer();
            }
        } else if (!(this.viewer instanceof SortableTreeViewer)) {
            this.viewer.getControl().dispose();
            this.createTreeViewer();
        }
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public void setViewerMenu(MenuManager manager) {
        this.menuManager = manager;
        if (this.viewer != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this.viewer);
        }
    }
}

