/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.eventmanager.Activator;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.eventmanager.views.helpers.SyslogLabelProvider;
import org.netxms.ui.eclipse.eventmanager.views.helpers.SyslogMonitorFilter;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.views.AbstractTraceView;

public class SyslogMonitor
extends AbstractTraceView
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.eventmanager.views.SyslogMonitor";
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_FACILITY = 3;
    public static final int COLUMN_HOSTNAME = 4;
    public static final int COLUMN_TAG = 5;
    public static final int COLUMN_MESSAGE = 6;
    private NXCSession session;
    private Action actionShowColor;
    private Action actionShowIcons;
    private SyslogLabelProvider labelProvider;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.session.addListener((SessionListener)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            new ConsoleJob(Messages.SyslogMonitor_SubscribeJob_Title, null, "org.netxms.ui.eclipse.eventmanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    SyslogMonitor.this.session.subscribe(2);
                }

                protected String getErrorMessage() {
                    return Messages.SyslogMonitor_SubscribeJob_Error;
                }
            }.start();
        }
    }

    protected void setupViewer(TableViewer viewer) {
        this.labelProvider = new SyslogLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.labelProvider.setShowColor(ps.getBoolean("SyslogMonitor.showColor"));
        this.labelProvider.setShowIcons(ps.getBoolean("SyslogMonitor.showIcons"));
        this.addColumn(Messages.SyslogMonitor_ColTimestamp, 150);
        this.addColumn(Messages.SyslogMonitor_ColSource, 200);
        this.addColumn(Messages.SyslogMonitor_ColSeverity, 90);
        this.addColumn(Messages.SyslogMonitor_ColFacility, 90);
        this.addColumn(Messages.SyslogMonitor_ColHostName, 130);
        this.addColumn(Messages.SyslogMonitor_ColTag, 90);
        this.addColumn(Messages.SyslogMonitor_ColMessage, 600);
        this.setFilter(new SyslogMonitorFilter());
    }

    protected void createActions() {
        super.createActions();
        this.actionShowColor = new Action(Messages.SyslogMonitor_ShowStatusColors, 2){

            public void run() {
                SyslogMonitor.this.labelProvider.setShowColor(SyslogMonitor.this.actionShowColor.isChecked());
                SyslogMonitor.this.refresh();
            }
        };
        this.actionShowColor.setChecked(this.labelProvider.isShowColor());
        this.actionShowIcons = new Action(Messages.SyslogMonitor_ShowStatusIcons, 2){

            public void run() {
                SyslogMonitor.this.labelProvider.setShowIcons(SyslogMonitor.this.actionShowIcons.isChecked());
                SyslogMonitor.this.refresh();
            }
        };
        this.actionShowIcons.setChecked(this.labelProvider.isShowIcons());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        super.fillLocalPullDown(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowColor);
        manager.add((IAction)this.actionShowIcons);
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 7) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SyslogMonitor.this.addElement(n.getObject());
                }
            });
        }
    }

    public void dispose() {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        ps.setValue("SyslogMonitor.showColor", this.labelProvider.isShowColor());
        ps.setValue("SyslogMonitor.showIcons", this.labelProvider.isShowIcons());
        this.session.removeListener((SessionListener)this);
        new ConsoleJob(Messages.SyslogMonitor_UnsubscribeJob_Title, null, "org.netxms.ui.eclipse.eventmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SyslogMonitor.this.session.unsubscribe(2);
            }

            protected String getErrorMessage() {
                return Messages.SyslogMonitor_UnsubscribeJob_Error;
            }
        }.start();
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected String getConfigPrefix() {
        return "SyslogMonitor";
    }
}

