/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolHandler;

public class ObjectToolsCache {
    private static Map<Long, ObjectTool> objectTools = new HashMap<Long, ObjectTool>();
    private static Map<String, ObjectToolHandler> handlers = new HashMap<String, ObjectToolHandler>();
    private static NXCSession session = null;

    public static void init(NXCSession session) {
        ObjectToolsCache.session = session;
        ObjectToolsCache.registerHandlers();
        ObjectToolsCache.reload();
        session.addListener((SessionListener)new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1009: {
                        ObjectToolsCache.onObjectToolChange(n.getSubCode());
                        break;
                    }
                    case 1015: {
                        ObjectToolsCache.onObjectToolDelete(n.getSubCode());
                    }
                }
            }
        });
    }

    private static void registerHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objecttools.toolhandlers");
        int i = 0;
        while (i < elements.length) {
            try {
                ObjectToolHandler handler = (ObjectToolHandler)elements[i].createExecutableExtension("class");
                handlers.put(elements[i].getAttribute("id"), handler);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reload() {
        try {
            List list = session.getObjectTools();
            Map<Long, ObjectTool> map = objectTools;
            synchronized (map) {
                objectTools.clear();
                for (ObjectTool tool : list) {
                    objectTools.put(tool.getId(), tool);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onObjectToolChange(long toolId) {
        new Thread(){

            @Override
            public void run() {
                ObjectToolsCache.reload();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onObjectToolDelete(long toolId) {
        Map<Long, ObjectTool> map = objectTools;
        synchronized (map) {
            objectTools.remove(toolId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTool[] getTools() {
        ObjectTool[] tools = null;
        Map<Long, ObjectTool> map = objectTools;
        synchronized (map) {
            tools = objectTools.values().toArray(new ObjectTool[objectTools.values().size()]);
        }
        return tools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTool findTool(long toolId) {
        ObjectTool tool;
        Map<Long, ObjectTool> map = objectTools;
        synchronized (map) {
            tool = objectTools.get(toolId);
        }
        return tool;
    }

    public static ObjectToolHandler findHandler(String toolId) {
        return handlers.get(toolId);
    }
}

