/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.Messages;

public class SystemRights
extends PropertyPage {
    private UserManager userManager;
    private AbstractUserObject object;
    private Map<Integer, Button> buttons = new HashMap<Integer, Button>();

    protected Control createContents(Composite parent) {
        this.userManager = (UserManager)ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractUserObject)this.getElement().getAdapter(AbstractUserObject.class);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.addCheckbox(dialogArea, 256, Messages.SystemRights_DeleteAlarms);
        this.addCheckbox(dialogArea, 128, Messages.SystemRights_ConfigureActions);
        this.addCheckbox(dialogArea, 32, Messages.SystemRights_ConfigureEvents);
        this.addCheckbox(dialogArea, 16, Messages.SystemRights_ViewEventConfig);
        this.addCheckbox(dialogArea, 65536, Messages.SystemRights_ConfigureSituations);
        this.addCheckbox(dialogArea, 64, Messages.SystemRights_EditEPP);
        this.addCheckbox(dialogArea, 4096, Messages.SystemRights_ManageScripts);
        this.addCheckbox(dialogArea, 2048, Messages.SystemRights_ConfigureObjTools);
        this.addCheckbox(dialogArea, 4, Messages.SystemRights_ConfigureTraps);
        this.addCheckbox(dialogArea, 32768, Messages.SystemRights_ManageAgents);
        this.addCheckbox(dialogArea, 512, Messages.SystemRights_ManagePackages);
        this.addCheckbox(dialogArea, 1024, Messages.SystemRights_ViewEventLog);
        this.addCheckbox(dialogArea, 16384, Messages.SystemRights_ViewAuditLog);
        this.addCheckbox(dialogArea, 8192, Messages.SystemRights_ViewTrapLog);
        this.addCheckbox(dialogArea, 0x800000, Messages.SystemRights_ManageMappingTables);
        this.addCheckbox(dialogArea, 2, Messages.SystemRights_EditServerConfig);
        this.addCheckbox(dialogArea, 0x100000, Messages.SystemRights_ReadFiles);
        this.addCheckbox(dialogArea, 0x400000, Messages.SystemRights_ManageFiles);
        this.addCheckbox(dialogArea, 0x200000, Messages.SystemRights_AccessConsole);
        this.addCheckbox(dialogArea, 8, Messages.SystemRights_ControlSessions);
        this.addCheckbox(dialogArea, 1, Messages.SystemRights_ManageUsers);
        this.addCheckbox(dialogArea, 131072, Messages.SystemRights_SendSMS);
        this.addCheckbox(dialogArea, 524288, Messages.SystemRights_RegisterAgents);
        this.addCheckbox(dialogArea, 262144, Messages.SystemRights_LoginAsMobile);
        return dialogArea;
    }

    private void addCheckbox(Composite parent, int access, String name) {
        Button b = new Button(parent, 32);
        b.setText(name);
        b.setSelection((this.object.getSystemRights() & access) != 0);
        this.buttons.put(access, b);
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        int systemRights = 0;
        for (Map.Entry<Integer, Button> e : this.buttons.entrySet()) {
            if (!e.getValue().getSelection()) continue;
            systemRights |= e.getKey().intValue();
        }
        this.object.setSystemRights(systemRights);
        new ConsoleJob(Messages.SystemRights_JobTitle, null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SystemRights.this.userManager.modifyUserDBObject(SystemRights.this.object, 16);
            }

            protected String getErrorMessage() {
                return Messages.SystemRights_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SystemRights.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

