/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.views.helpers;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.console.tools.RegionalSettings;
import org.netxms.ui.eclipse.logviewer.Activator;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LogLabelProvider
implements ITableLabelProvider {
    public static final String[] ALARM_STATE_TEXTS = new String[]{Messages.LogLabelProvider_Outstanding, Messages.LogLabelProvider_Acknowledged, Messages.LogLabelProvider_Resolved, Messages.LogLabelProvider_Terminated};
    public static final String[] ALARM_HD_STATE_TEXTS = new String[]{Messages.LogLabelProvider_Ignored, Messages.LogLabelProvider_Open, Messages.LogLabelProvider_Closed};
    private LogColumn[] columns;
    private NXCSession session;
    private Image[] alarmStateImages;
    private WorkbenchLabelProvider wbLabelProvider;

    public LogLabelProvider(Log logHandle) {
        Collection c = logHandle.getColumns();
        this.columns = c.toArray(new LogColumn[c.size()]);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.alarmStateImages = new Image[4];
        this.alarmStateImages[0] = Activator.getImageDescriptor("icons/outstanding.png").createImage();
        this.alarmStateImages[1] = Activator.getImageDescriptor("icons/acknowledged.png").createImage();
        this.alarmStateImages[2] = Activator.getImageDescriptor("icons/resolved.png").createImage();
        this.alarmStateImages[3] = Activator.getImageDescriptor("icons/terminated.png").createImage();
        this.wbLabelProvider = new WorkbenchLabelProvider();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        String value = (String)((List)element).get(columnIndex);
        switch (this.columns[columnIndex].getType()) {
            case 1: {
                try {
                    int severity = Integer.parseInt(value);
                    return StatusDisplayInfo.getStatusImage((int)severity);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 7: {
                try {
                    int state = Integer.parseInt(value);
                    return this.alarmStateImages[state & 0xF];
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 2: {
                try {
                    long id = Long.parseLong(value);
                    AbstractObject object = this.session.findObjectById(id);
                    return object != null ? this.wbLabelProvider.getImage((Object)object) : null;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 3: {
                try {
                    long id = Long.parseLong(value);
                    AbstractUserObject user = this.session.findUserDBObjectById(id);
                    return user != null ? this.wbLabelProvider.getImage((Object)user) : null;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnText(Object element, int columnIndex) {
        String value = (String)((List)element).get(columnIndex);
        switch (this.columns[columnIndex].getType()) {
            case 5: {
                try {
                    long timestamp = Long.parseLong(value);
                    Date date = new Date(timestamp * 1000L);
                    return RegionalSettings.getDateTimeFormat().format(date);
                }
                catch (NumberFormatException numberFormatException) {
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 2: {
                try {
                    String string;
                    long id = Long.parseLong(value);
                    if (id == 0L) {
                        return "";
                    }
                    AbstractObject object = this.session.findObjectById(id);
                    if (object != null) {
                        string = object.getObjectName();
                        return string;
                    }
                    string = "[" + id + "]";
                    return string;
                }
                catch (NumberFormatException numberFormatException) {
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 1: {
                try {
                    int severity = Integer.parseInt(value);
                    return StatusDisplayInfo.getStatusText((int)severity);
                }
                catch (NumberFormatException numberFormatException) {
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 3: {
                try {
                    long id = Long.parseLong(value);
                    AbstractUserObject user = this.session.findUserDBObjectById(id);
                    if (user == null) return null;
                    String string = this.wbLabelProvider.getText((Object)user);
                    return string;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 4: {
                try {
                    String string;
                    long code = Long.parseLong(value);
                    EventTemplate evt = this.session.findEventTemplateByCode(code);
                    if (evt != null) {
                        string = evt.getName();
                        return string;
                    }
                    string = "[" + code + "]";
                    return string;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 7: {
                try {
                    int state = Integer.parseInt(value);
                    return ALARM_STATE_TEXTS[state & 0xF];
                }
                catch (Exception exception) {
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 8: {
                try {
                    int state = Integer.parseInt(value);
                    return ALARM_HD_STATE_TEXTS[state];
                }
                catch (Exception exception) {
                    return Messages.LogLabelProvider_Error;
                }
            }
        }
        return value;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.alarmStateImages.length) {
            if (this.alarmStateImages[i] != null) {
                this.alarmStateImages[i].dispose();
            }
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

