/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.AbstractChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.BarChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ComparisonChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.LineChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TubeChartConfig;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class AbstractChart
extends PropertyPage {
    private AbstractChartConfig config;
    private LabeledText title;
    private Spinner timeRange;
    private Combo timeUnits;
    private Spinner refreshRate;
    private Combo legendPosition;
    private Button checkShowTitle;
    private Button checkShowLegend;
    private Button checkShowGrid;
    private Button checkShowIn3D;
    private Button checkTranslucent;
    private Button checkTransposed;

    protected Control createContents(Composite parent) {
        this.config = (AbstractChartConfig)this.getElement().getAdapter(AbstractChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel(Messages.AbstractChart_Title);
        this.title.setText(this.config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.legendPosition = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.AbstractChart_LegendPosition, (Object)"WidgetHelper::default_layout_data");
        this.legendPosition.add(Messages.AbstractChart_Left);
        this.legendPosition.add(Messages.AbstractChart_Right);
        this.legendPosition.add(Messages.AbstractChart_Top);
        this.legendPosition.add(Messages.AbstractChart_Bottom);
        this.legendPosition.select(this.positionIndexFromValue(this.config.getLegendPosition()));
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(Messages.AbstractChart_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowTitle = new Button((Composite)optionsGroup, 32);
        this.checkShowTitle.setText(Messages.AbstractChart_ShowTitle);
        this.checkShowTitle.setSelection(this.config.isShowTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowTitle.setLayoutData((Object)gd);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        this.checkShowLegend.setText(Messages.AbstractChart_ShowLegend);
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowLegend.setLayoutData((Object)gd);
        if (this.config instanceof ComparisonChartConfig) {
            this.checkShowIn3D = new Button((Composite)optionsGroup, 32);
            this.checkShowIn3D.setText(Messages.AbstractChart_3DView);
            this.checkShowIn3D.setSelection(((ComparisonChartConfig)this.config).isShowIn3D());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkShowIn3D.setLayoutData((Object)gd);
            this.checkTranslucent = new Button((Composite)optionsGroup, 32);
            this.checkTranslucent.setText(Messages.AbstractChart_Translucent);
            this.checkTranslucent.setSelection(((ComparisonChartConfig)this.config).isTranslucent());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkTranslucent.setLayoutData((Object)gd);
            if (this.config instanceof BarChartConfig || this.config instanceof TubeChartConfig) {
                this.checkTransposed = new Button((Composite)optionsGroup, 32);
                this.checkTransposed.setText(Messages.AbstractChart_Transposed);
                this.checkTransposed.setSelection(this.config instanceof BarChartConfig ? ((BarChartConfig)this.config).isTransposed() : ((TubeChartConfig)this.config).isTransposed());
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.checkTransposed.setLayoutData((Object)gd);
            }
        }
        if (this.config instanceof LineChartConfig) {
            this.checkShowGrid = new Button((Composite)optionsGroup, 32);
            this.checkShowGrid.setText(Messages.AbstractChart_ShowGrid);
            this.checkShowGrid.setSelection(((LineChartConfig)this.config).isShowGrid());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkShowGrid.setLayoutData((Object)gd);
            Composite timeRangeArea = new Composite(dialogArea, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 5;
            timeRangeArea.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            timeRangeArea.setLayoutData((Object)gd);
            this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeRangeArea, (int)2048, (String)Messages.AbstractChart_TimeInterval, (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
            this.timeRange.setSelection(((LineChartConfig)this.config).getTimeRange());
            this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeRangeArea, (int)8, (String)Messages.AbstractChart_TimeUnits, (Object)"WidgetHelper::default_layout_data");
            this.timeUnits.add(Messages.AbstractChart_Minutes);
            this.timeUnits.add(Messages.AbstractChart_Hours);
            this.timeUnits.add(Messages.AbstractChart_Days);
            this.timeUnits.select(((LineChartConfig)this.config).getTimeUnits());
        }
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshRate = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.AbstractChart_RefreshInterval, (int)1, (int)10000, (Object)gd);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        return dialogArea;
    }

    private int positionIndexFromValue(int value) {
        switch (value) {
            case 8: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public boolean performOk() {
        this.config.setTitle(this.title.getText());
        this.config.setLegendPosition(1 << this.legendPosition.getSelectionIndex());
        this.config.setShowTitle(this.checkShowTitle.getSelection());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        if (this.config instanceof ComparisonChartConfig) {
            ((ComparisonChartConfig)this.config).setShowIn3D(this.checkShowIn3D.getSelection());
            ((ComparisonChartConfig)this.config).setTranslucent(this.checkTranslucent.getSelection());
            if (this.config instanceof BarChartConfig) {
                ((BarChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
            } else if (this.config instanceof TubeChartConfig) {
                ((TubeChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
            }
        }
        if (this.config instanceof LineChartConfig) {
            ((LineChartConfig)this.config).setTimeRange(this.timeRange.getSelection());
            ((LineChartConfig)this.config).setTimeUnits(this.timeUnits.getSelectionIndex());
            ((LineChartConfig)this.config).setShowGrid(this.checkShowGrid.getSelection());
        }
        return true;
    }
}

