/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditColumnDialog
extends Dialog {
    private ColumnDefinition column;
    private LabeledText name;
    private LabeledText displayName;
    private Combo dataType;
    private Combo aggregationFunction;
    private Button checkInstanceColumn;
    private Button checkInstanceLabelColumn;
    private LabeledText snmpOid;

    public EditColumnDialog(Shell parentShell, ColumnDefinition column) {
        super(parentShell);
        this.column = column;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(Messages.EditColumnDialog_ColumnDefinition) + this.column.getName());
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.column.getName());
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.displayName = new LabeledText(dialogArea, 0);
        this.displayName.setLabel("Display name");
        this.displayName.setText(this.column.getDisplayName());
        this.displayName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.dataType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Data type", (Object)new GridData(4, 0x1000000, true, false));
        this.dataType.add(Messages.TableColumnLabelProvider_in32);
        this.dataType.add(Messages.TableColumnLabelProvider_uint32);
        this.dataType.add(Messages.TableColumnLabelProvider_int64);
        this.dataType.add(Messages.TableColumnLabelProvider_uint64);
        this.dataType.add(Messages.TableColumnLabelProvider_string);
        this.dataType.add(Messages.TableColumnLabelProvider_float);
        this.dataType.select(this.column.getDataType());
        this.aggregationFunction = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Aggregation function", (Object)new GridData(4, 0x1000000, true, false));
        this.aggregationFunction.add(Messages.TableColumnLabelProvider_SUM);
        this.aggregationFunction.add(Messages.TableColumnLabelProvider_AVG);
        this.aggregationFunction.add(Messages.TableColumnLabelProvider_MIN);
        this.aggregationFunction.add(Messages.TableColumnLabelProvider_MAX);
        this.aggregationFunction.select(this.column.getAggregationFunction());
        this.checkInstanceColumn = new Button(dialogArea, 32);
        this.checkInstanceColumn.setText("This column is instance (key) column");
        this.checkInstanceColumn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.checkInstanceColumn.setSelection(this.column.isInstanceColumn());
        this.checkInstanceLabelColumn = new Button(dialogArea, 32);
        this.checkInstanceLabelColumn.setText("This column is instance label column");
        this.checkInstanceLabelColumn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.checkInstanceLabelColumn.setSelection(this.column.isInstanceLabelColumn());
        this.snmpOid = new LabeledText(dialogArea, 0);
        this.snmpOid.setLabel("SNMP Object ID");
        this.snmpOid.setText(this.column.getSnmpObjectId() != null ? this.column.getSnmpObjectId().toString() : "");
        this.snmpOid.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected void okPressed() {
        String oidText = this.snmpOid.getText().trim();
        if (!oidText.isEmpty()) {
            try {
                SnmpObjectId oid = SnmpObjectId.parseSnmpObjectId((String)oidText);
                this.column.setSnmpObjectId(oid);
            }
            catch (SnmpObjectIdFormatException snmpObjectIdFormatException) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Entered SNMP object ID is invalid");
                return;
            }
        } else {
            this.column.setSnmpObjectId(null);
        }
        this.column.setName(this.name.getText().trim());
        this.column.setDisplayName(this.displayName.getText().trim());
        this.column.setInstanceColumn(this.checkInstanceColumn.getSelection());
        this.column.setInstanceLabelColumn(this.checkInstanceLabelColumn.getSelection());
        this.column.setDataType(this.dataType.getSelectionIndex());
        this.column.setAggregationFunction(this.aggregationFunction.getSelectionIndex());
        super.okPressed();
    }
}

