/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.TransformationTestResult;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class TestTransformationDlg
extends Dialog {
    private static final int RUN = 111;
    private long nodeId;
    private String script;
    private LabeledText inputValue;
    private CLabel status;
    private LabeledText result;
    private Image imageWaiting;

    public TestTransformationDlg(Shell parentShell, long nodeId, String script) {
        super(parentShell);
        this.nodeId = nodeId;
        this.script = script;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button b = this.createButton(parent, 111, "&Run", true);
        b.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestTransformationDlg.this.runScript();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 1, "Close", false);
    }

    protected Control createDialogArea(Composite parent) {
        this.imageWaiting = Activator.getImageDescriptor("icons/waiting.png").createImage();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TestTransformationDlg.this.imageWaiting.dispose();
            }
        });
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.inputValue = new LabeledText(dialogArea, 0);
        this.inputValue.setLabel("Input value");
        GridData gd = new GridData();
        gd.widthHint = 300;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.inputValue.setLayoutData((Object)gd);
        this.status = new CLabel(dialogArea, 2048);
        this.status.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.status.setText("Idle");
        this.status.setImage(StatusDisplayInfo.getStatusImage((int)5));
        this.result = new LabeledText(dialogArea, 0);
        this.result.setLabel("Result");
        this.result.getTextControl().setEditable(false);
        this.result.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return dialogArea;
    }

    private void runScript() {
        this.getButton(111).setEnabled(false);
        final String input = this.inputValue.getText();
        this.inputValue.getTextControl().setEditable(false);
        this.status.setText("Running...");
        this.status.setImage(this.imageWaiting);
        this.result.setText("");
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Execute script on server", null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final TransformationTestResult r = session.testTransformationScript(TestTransformationDlg.this.nodeId, TestTransformationDlg.this.script, input);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (TestTransformationDlg.this.getShell() == null || TestTransformationDlg.this.getShell().isDisposed()) {
                            return;
                        }
                        if (r.success) {
                            TestTransformationDlg.this.status.setText("Success");
                            TestTransformationDlg.this.status.setImage(StatusDisplayInfo.getStatusImage((int)0));
                        } else {
                            TestTransformationDlg.this.status.setText("Failure");
                            TestTransformationDlg.this.status.setImage(StatusDisplayInfo.getStatusImage((int)4));
                        }
                        TestTransformationDlg.this.result.setText(r.result);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot execute script";
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (TestTransformationDlg.this.getShell() == null || TestTransformationDlg.this.getShell().isDisposed()) {
                            return;
                        }
                        TestTransformationDlg.this.getButton(111).setEnabled(true);
                        TestTransformationDlg.this.inputValue.getTextControl().setEditable(true);
                        TestTransformationDlg.this.inputValue.getTextControl().setFocus();
                    }
                });
            }
        }.start();
    }
}

