/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.client.datacollection.DciSummaryTableColumn;
import org.netxms.client.datacollection.DciValue;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.EditDciSummaryTableColumnDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectDciDialog;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.SummaryTableColumnLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class SummaryTableColumns
extends PropertyPage {
    private static final String COLUMN_SETTINGS_PREFIX = "SummaryTableColumns.ColumnList";
    private DciSummaryTable table;
    private List<DciSummaryTableColumn> columns;
    private TableViewer viewer;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private Button importButton;

    protected Control createContents(Composite parent) {
        this.table = (DciSummaryTable)this.getElement().getAdapter(DciSummaryTable.class);
        this.columns = new ArrayList<DciSummaryTableColumn>(this.table.getColumns().size());
        for (DciSummaryTableColumn c : this.table.getColumns()) {
            this.columns.add(new DciSummaryTableColumn(c));
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText(Messages.SummaryTableColumns_Columns);
        this.viewer = new TableViewer(dialogArea, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.setupColumnList();
        this.viewer.setInput((Object)this.columns.toArray());
        Composite leftButtons = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(Messages.Thresholds_Up);
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SummaryTableColumns.this.moveUp();
            }
        });
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(Messages.Thresholds_Down);
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SummaryTableColumns.this.moveDown();
            }
        });
        Composite buttons = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.importButton = new Button(buttons, 8);
        this.importButton.setText(Messages.SummaryTableColumns_Import);
        RowData rd = new RowData();
        rd.width = 90;
        this.importButton.setLayoutData((Object)rd);
        this.importButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SummaryTableColumns.this.importColumns();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Messages.Thresholds_Add);
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SummaryTableColumns.this.addColumn();
            }
        });
        this.modifyButton = new Button(buttons, 8);
        this.modifyButton.setText(Messages.Thresholds_Edit);
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SummaryTableColumns.this.editColumn();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(Messages.Thresholds_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SummaryTableColumns.this.deleteColumns();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int index = SummaryTableColumns.this.columns.indexOf(selection.getFirstElement());
                SummaryTableColumns.this.upButton.setEnabled(selection.size() == 1 && index > 0);
                SummaryTableColumns.this.downButton.setEnabled(selection.size() == 1 && index >= 0 && index < SummaryTableColumns.this.columns.size() - 1);
                SummaryTableColumns.this.modifyButton.setEnabled(selection.size() == 1);
                SummaryTableColumns.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SummaryTableColumns.this.editColumn();
            }
        });
        return dialogArea;
    }

    private void setupColumnList() {
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.SummaryTableColumns_Name);
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        column.setText(Messages.SummaryTableColumns_DciName);
        column.setWidth(250);
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SummaryTableColumnLabelProvider());
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob(Messages.SummaryTableColumns_JobName, null, "org.netxms.ui.eclipse.datacollection", null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DciSummaryTable dciSummaryTable = SummaryTableColumns.this.table;
                synchronized (dciSummaryTable) {
                    SummaryTableColumns.this.table.getColumns().clear();
                    SummaryTableColumns.this.table.getColumns().addAll(SummaryTableColumns.this.columns);
                    int id = session.modifyDciSummaryTable(SummaryTableColumns.this.table);
                    SummaryTableColumns.this.table.setId(id);
                }
            }

            protected String getErrorMessage() {
                return Messages.SummaryTableColumns_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SummaryTableColumns.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.saveSettings();
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.saveSettings();
        this.applyChanges(true);
    }

    public boolean performCancel() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
    }

    private void moveUp() {
        DciSummaryTableColumn column;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.columns.indexOf(column = (DciSummaryTableColumn)selection.getFirstElement())) > 0) {
            Collections.swap(this.columns, index - 1, index);
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }

    private void moveDown() {
        DciSummaryTableColumn column;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.columns.indexOf(column = (DciSummaryTableColumn)selection.getFirstElement())) < this.columns.size() - 1 && index >= 0) {
            Collections.swap(this.columns, index + 1, index);
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }

    private void deleteColumns() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.columns.remove(it.next());
            }
            this.viewer.setInput((Object)this.columns.toArray());
        }
    }

    private void editColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            DciSummaryTableColumn column = (DciSummaryTableColumn)selection.getFirstElement();
            EditDciSummaryTableColumnDlg dlg = new EditDciSummaryTableColumnDlg(this.getShell(), column);
            if (dlg.open() == 0) {
                this.viewer.update((Object)column, null);
            }
        }
    }

    private void addColumn() {
        DciSummaryTableColumn column = new DciSummaryTableColumn("", "", 0);
        EditDciSummaryTableColumnDlg dlg = new EditDciSummaryTableColumnDlg(this.getShell(), column);
        if (dlg.open() == 0) {
            this.columns.add(column);
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }

    private void importColumns() {
        SelectDciDialog dialog = new SelectDciDialog(this.getShell(), 0L);
        dialog.setAllowTemplateItems(true);
        dialog.setEnableEmptySelection(false);
        if (dialog.open() == 0) {
            DciValue selection = dialog.getSelection();
            DciSummaryTableColumn column = new DciSummaryTableColumn(selection.getDescription(), selection.getName(), 0);
            this.columns.add(column);
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }
}

