/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.views.helpers.TableContentProvider;
import org.netxms.ui.eclipse.datacollection.views.helpers.TableItemComparator;
import org.netxms.ui.eclipse.datacollection.views.helpers.TableLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SummaryTable
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.views.SummaryTable";
    private NXCSession session;
    private int tableId;
    private long baseObjectId;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.tableId = Integer.parseInt(parts[0]);
        this.baseObjectId = Long.parseLong(parts[1]);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new SortableTableViewer(parent, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                SummaryTable.this.refreshTable();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SummaryTable.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void refreshTable() {
        this.viewer.setInput(null);
        new ConsoleJob(Messages.SummaryTable_JobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = SummaryTable.this.session.queryDciSummaryTable(SummaryTable.this.tableId, SummaryTable.this.baseObjectId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SummaryTable.this.updateViewer(table);
                    }
                });
            }

            protected String getErrorMessage() {
                return Messages.SummaryTable_JobError;
            }
        }.start();
    }

    private void updateViewer(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 100);
            this.viewer.createColumns(names, widths, 0, 128);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)("SummaryTable." + Integer.toString(this.tableId)));
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)SummaryTable.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)("SummaryTable." + Integer.toString(SummaryTable.this.tableId)));
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        this.viewer.setInput((Object)table);
    }

    public void setTable(Table table) {
        AbstractObject object = this.session.findObjectById(this.baseObjectId);
        this.setPartName(String.valueOf(table.getTitle()) + " - " + (object != null ? object.getObjectName() : "[" + this.baseObjectId + "]"));
        this.updateViewer(table);
    }
}

