/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.actions;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ShowIPRoute
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private Node sourceNode;
    private Node targetNode;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        if (this.sourceNode != null && this.targetNode == null) {
            ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.window.getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
            if (dlg.open() != 0) {
                return;
            }
            AbstractObject[] selection = dlg.getSelectedObjects(Node.class);
            if (selection.length == 0) {
                MessageDialogHelper.openError((Shell)this.window.getShell(), (String)Messages.ShowIPRoute_Error, (String)Messages.ShowIPRoute_InvalidTarget);
                return;
            }
            this.targetNode = (Node)selection[0];
        }
        if (this.sourceNode != null && this.targetNode != null) {
            try {
                this.window.getActivePage().showView("org.netxms.ui.eclipse.networkmaps.views.IPRouteMap", String.valueOf(Long.toString(this.sourceNode.getObjectId())) + "&" + Long.toString(this.targetNode.getObjectId()), 1);
            }
            catch (PartInitException e) {
                MessageDialogHelper.openError((Shell)this.window.getShell(), (String)Messages.ShowIPRoute_Error, (String)String.format(Messages.ShowIPRoute_ErrorOpenView, e.getLocalizedMessage()));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        List l;
        this.sourceNode = null;
        this.targetNode = null;
        if (selection instanceof IStructuredSelection && (l = ((IStructuredSelection)selection).toList()).size() > 0 && l.get(0) instanceof Node) {
            this.sourceNode = (Node)l.get(0);
            if (l.size() > 1 && l.get(1) instanceof Node) {
                this.targetNode = (Node)l.get(1);
            }
        }
    }
}

