/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Activator;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpTrapMonitorFilter;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpTrapMonitorLabelProvider;
import org.netxms.ui.eclipse.views.AbstractTraceView;

public class SnmpTrapMonitor
extends AbstractTraceView
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.snmp.views.SnmpTrapMonitor";
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE_IP = 1;
    public static final int COLUMN_SOURCE_NODE = 2;
    public static final int COLUMN_OID = 3;
    public static final int COLUMN_VARBINDS = 4;
    private NXCSession session;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.session.addListener((SessionListener)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            new ConsoleJob(Messages.SnmpTrapMonitor_SubscribeJob_Title, null, "org.netxms.ui.eclipse.snmp", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    SnmpTrapMonitor.this.session.subscribe(16);
                }

                protected String getErrorMessage() {
                    return Messages.SnmpTrapMonitor_SubscribeJob_Error;
                }
            }.start();
        }
    }

    protected void setupViewer(TableViewer viewer) {
        this.addColumn(Messages.SnmpTrapMonitor_ColTime, 150);
        this.addColumn(Messages.SnmpTrapMonitor_ColSourceIP, 120);
        this.addColumn(Messages.SnmpTrapMonitor_ColSourceNode, 200);
        this.addColumn(Messages.SnmpTrapMonitor_ColOID, 200);
        this.addColumn(Messages.SnmpTrapMonitor_ColVarbinds, 600);
        viewer.setLabelProvider((IBaseLabelProvider)new SnmpTrapMonitorLabelProvider());
        this.setFilter(new SnmpTrapMonitorFilter());
    }

    protected IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected String getConfigPrefix() {
        return "SnmpTrapMonitor";
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 8) {
            this.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    SnmpTrapMonitor.this.addElement(n.getObject());
                }
            });
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        new ConsoleJob(Messages.SnmpTrapMonitor_UnsubscribeJob_Title, null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SnmpTrapMonitor.this.session.unsubscribe(16);
            }

            protected String getErrorMessage() {
                return Messages.SnmpTrapMonitor_UnsubscribeJob_Error;
            }
        }.start();
        super.dispose();
    }
}

