/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class Connection
extends OverviewPageElement {
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private CLabel nodeLabel;
    private CLabel interfaceLabel;
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();

    public Connection(Composite parent, AbstractObject object) {
        super(parent, object);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Connection.this.labelProvider.dispose();
            }
        });
    }

    protected Control createClientArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        area.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)this.getDisplay()));
        this.nodeLabel = new CLabel(area, 0);
        this.nodeLabel.setBackground(area.getBackground());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.nodeLabel.setLayoutData((Object)gd);
        this.interfaceLabel = new CLabel(area, 0);
        this.interfaceLabel.setBackground(area.getBackground());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = 15;
        this.interfaceLabel.setLayoutData((Object)gd);
        return area;
    }

    @Override
    protected String getTitle() {
        return "Connection";
    }

    @Override
    void onObjectChange() {
        if (this.getObject() == null || !(this.getObject() instanceof Interface)) {
            return;
        }
        Interface iface = (Interface)this.getObject();
        long peerNodeId = iface.getPeerNodeId();
        if (peerNodeId != 0L) {
            AbstractObject node = this.session.findObjectById(peerNodeId);
            this.nodeLabel.setText(node != null ? node.getObjectName() : "<" + peerNodeId + ">");
            this.nodeLabel.setImage(this.labelProvider.getImage((Object)node));
        } else {
            this.nodeLabel.setText("N/A");
        }
        long peerInterfaceId = iface.getPeerInterfaceId();
        if (peerInterfaceId != 0L) {
            AbstractObject peerIface = this.session.findObjectById(peerInterfaceId);
            this.interfaceLabel.setText(peerIface != null ? peerIface.getObjectName() : "<" + peerInterfaceId + ">");
            this.interfaceLabel.setImage(this.labelProvider.getImage((Object)peerIface));
        } else {
            this.interfaceLabel.setText("N/A");
        }
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof Interface && ((Interface)object).getPeerNodeId() != 0L;
    }
}

