/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public abstract class TableElement
extends OverviewPageElement {
    private Table table;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopyValue;

    public TableElement(Composite parent, AbstractObject object) {
        super(parent, object);
    }

    protected Control createClientArea(Composite parent) {
        this.table = new Table(parent, 98564);
        this.setupTable();
        this.createActions();
        this.createPopupMenu();
        this.fillTableInternal();
        return this.table;
    }

    private void setupTable() {
        TableColumn tc = new TableColumn(this.table, 16384);
        tc.setText("Name");
        tc = new TableColumn(this.table, 16384);
        tc.setText("Value");
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        this.table.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)this.getDisplay()));
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                GC gc = event.gc;
                gc.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)TableElement.this.getDisplay()));
                gc.fillRectangle(event.x, event.y, event.width, event.height);
            }
        });
    }

    protected void createActions() {
        this.actionCopy = new Action("Copy to clipboard"){

            public void run() {
                int index = TableElement.this.table.getSelectionIndex();
                if (index >= 0) {
                    TableItem item = TableElement.this.table.getItem(index);
                    WidgetHelper.copyToClipboard((String)(String.valueOf(item.getText(0)) + "=" + item.getText(1)));
                }
            }
        };
        this.actionCopyName = new Action("Copy &name to clipboard"){

            public void run() {
                int index = TableElement.this.table.getSelectionIndex();
                if (index >= 0) {
                    TableItem item = TableElement.this.table.getItem(index);
                    WidgetHelper.copyToClipboard((String)item.getText(0));
                }
            }
        };
        this.actionCopyValue = new Action("Copy &value to clipboard"){

            public void run() {
                int index = TableElement.this.table.getSelectionIndex();
                if (index >= 0) {
                    TableItem item = TableElement.this.table.getItem(index);
                    WidgetHelper.copyToClipboard((String)item.getText(1));
                }
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableElement.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyName);
        manager.add((IAction)this.actionCopyValue);
    }

    protected abstract void fillTable();

    private void fillTableInternal() {
        if (this.getObject() == null) {
            return;
        }
        this.fillTable();
        this.table.getColumn(0).pack();
        this.table.getColumn(1).pack();
    }

    protected void addPair(String attr, String value, boolean allowEmpty) {
        if (!allowEmpty && (value == null || value.isEmpty())) {
            return;
        }
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, attr);
        item.setText(1, value != null ? value : "");
    }

    protected void addPair(String attr, String value) {
        this.addPair(attr, value, true);
    }

    @Override
    protected void onObjectChange() {
        this.table.removeAll();
        this.fillTableInternal();
    }
}

