/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectmanager.actions.MultipleObjectAction;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class DeleteObject
extends MultipleObjectAction {
    @Override
    protected boolean confirm() {
        IStructuredSelection selection = this.getSelection();
        String question = selection.size() == 1 ? "Are you sure you want to delete '" + ((AbstractObject)selection.getFirstElement()).getObjectName() + "'?" : "Are you sure you want to delete selected objects?";
        boolean confirmed = MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)"Confirm Delete", (String)question);
        return confirmed;
    }

    @Override
    protected void runObjectAction(NXCSession session, AbstractObject object) throws Exception {
        session.deleteObject(object.getObjectId());
    }

    @Override
    protected String formatJobDescription(AbstractObject object) {
        return String.format("Delete object %s [%d]", object.getObjectName(), object.getObjectId());
    }

    @Override
    protected String formatErrorMessage(AbstractObject object, Display display) {
        return String.format("Cannot delete object %s [%d]", object.getObjectName(), object.getObjectId());
    }
}

