/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateZoneDialog
extends Dialog {
    private LabeledText nameField;
    private LabeledText zoneIdField;
    private String name;
    private long zoneId;

    public CreateZoneDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Zone Object");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel("Name");
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.nameField.setLayoutData((Object)gd);
        this.zoneIdField = new LabeledText(dialogArea, 0);
        this.zoneIdField.setLabel("Zone ID");
        this.zoneIdField.getTextControl().setTextLimit(12);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.zoneIdField.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        try {
            this.zoneId = Long.parseLong(this.zoneIdField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Zone ID must be positive integer");
            return;
        }
        if (this.zoneId <= 0L) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Zone ID must be positive integer");
            return;
        }
        this.name = this.nameField.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please provide non-empty object name");
            return;
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public long getZoneId() {
        return this.zoneId;
    }
}

