/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Condition;
import org.netxms.ui.eclipse.console.widgets.StatusSelector;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ConditionEvents
extends PropertyPage {
    private Condition object;
    private EventSelector activationEvent;
    private EventSelector deactivationEvent;
    private ObjectSelector sourceObject;
    private StatusSelector activeStatus;
    private StatusSelector inactiveStatus;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Condition)this.getElement().getAdapter(Condition.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Group eventGroup = new Group(dialogArea, 0);
        eventGroup.setText("Events");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        eventGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        eventGroup.setLayout((Layout)layout);
        this.activationEvent = new EventSelector((Composite)eventGroup, 0);
        this.activationEvent.setLabel("Activation event");
        this.activationEvent.setEventCode((long)this.object.getActivationEvent());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.activationEvent.setLayoutData((Object)gd);
        this.deactivationEvent = new EventSelector((Composite)eventGroup, 0);
        this.deactivationEvent.setLabel("Deactivation event");
        this.deactivationEvent.setEventCode((long)this.object.getDeactivationEvent());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.deactivationEvent.setLayoutData((Object)gd);
        this.sourceObject = new ObjectSelector((Composite)eventGroup, 0, true);
        this.sourceObject.setLabel("Source object for events");
        this.sourceObject.setEmptySelectionName("<server>");
        this.sourceObject.setObjectId(this.object.getEventSourceObject());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.sourceObject.setLayoutData((Object)gd);
        Group statusGroup = new Group(dialogArea, 0);
        statusGroup.setText("Status");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        statusGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        statusGroup.setLayout((Layout)layout);
        this.activeStatus = new StatusSelector((Composite)statusGroup, 0, 4);
        this.activeStatus.setLabel("Active status");
        this.activeStatus.setSelection(this.object.getActiveStatus());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.activeStatus.setLayoutData((Object)gd);
        this.inactiveStatus = new StatusSelector((Composite)statusGroup, 0, 4);
        this.inactiveStatus.setLabel("Inactive status");
        this.inactiveStatus.setSelection(this.object.getInactiveStatus());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.inactiveStatus.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setActivationEvent((int)this.activationEvent.getEventCode());
        md.setDeactivationEvent((int)this.deactivationEvent.getEventCode());
        md.setSourceObject(this.sourceObject.getObjectId());
        md.setActiveStatus(this.activeStatus.getSelection());
        md.setInactiveStatus(this.inactiveStatus.getSelection());
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update condition events configuration", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return "Cannot change condition events configuration";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ConditionEvents.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

