/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class InterfacePolling
extends PropertyPage {
    private Spinner pollCount;
    private Combo expectedState;
    private Button checkExcludeFromTopology;
    private Interface object;
    private int currentPollCount;
    private int currentExpectedState;
    private boolean currentExcludeFlag;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Interface)this.getElement().getAdapter(Interface.class);
        if (this.object == null) {
            return dialogArea;
        }
        this.currentPollCount = this.object.getRequiredPollCount();
        this.currentExpectedState = this.object.getExpectedState();
        this.currentExcludeFlag = this.object.isExcludedFromTopology();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.pollCount = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)"Required poll count", (int)0, (int)1000, (Object)"WidgetHelper::default_layout_data");
        this.pollCount.setSelection(this.object.getRequiredPollCount());
        this.expectedState = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)"Expected state", (Object)"WidgetHelper::default_layout_data");
        this.expectedState.add("UP");
        this.expectedState.add("DOWN");
        this.expectedState.add("IGNORE");
        this.expectedState.select(this.object.getExpectedState());
        this.checkExcludeFromTopology = new Button(dialogArea, 32);
        this.checkExcludeFromTopology.setText("&Exclude this interface from network topology");
        this.checkExcludeFromTopology.setSelection(this.object.isExcludedFromTopology());
        this.checkExcludeFromTopology.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (this.expectedState.getSelectionIndex() == this.currentExpectedState && this.pollCount.getSelection() == this.currentPollCount && this.checkExcludeFromTopology.getSelection() == this.currentExcludeFlag) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final NXCObjectModificationData data = new NXCObjectModificationData(this.object.getObjectId());
        data.setExpectedState(this.expectedState.getSelectionIndex());
        data.setRequiredPolls(this.pollCount.getSelection());
        data.setObjectFlags(this.checkExcludeFromTopology.getSelection() ? 4 : 0);
        new ConsoleJob("Update interface polling configuration", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(data);
            }

            protected String getErrorMessage() {
                return String.format("Cannot modify interface object %s", InterfacePolling.this.object.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            InterfacePolling.this.currentExpectedState = data.getExpectedState();
                            InterfacePolling.this.currentPollCount = data.getRequiredPolls();
                            InterfacePolling.this.currentExcludeFlag = (data.getObjectFlags() & 4) != 0;
                            InterfacePolling.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

