/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImageSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class MapAppearance
extends PropertyPage {
    private AbstractObject object;
    private ImageSelector image;
    private ObjectSelector submap = null;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.image = new ImageSelector(dialogArea, 0);
        this.image.setLabel("Presentation image");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.image.setLayoutData((Object)gd);
        this.image.setImageGuid(this.object.getImage(), false);
        if (!(this.object instanceof NetworkMap)) {
            this.submap = new ObjectSelector(dialogArea, 0, true);
            this.submap.setLabel("Drill-down submap");
            this.submap.setObjectClass(NetworkMap.class);
            this.submap.setObjectId(this.object.getSubmapId());
            this.submap.setClassFilter(ObjectSelectionDialog.createNetworkMapSelectionFilter());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.submap.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData data = new NXCObjectModificationData(this.object.getObjectId());
        data.setImage(this.image.getImageGuid());
        if (this.submap != null) {
            data.setSubmapId(this.submap.getObjectId());
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update object's map appearance", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(data);
            }

            protected String getErrorMessage() {
                return "Cannot modify object " + MapAppearance.this.object.getObjectName();
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            MapAppearance.this.setValid(true);
                        }
                    });
                }
            }
        }.schedule();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

