/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.netxms.api.client.Session;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.TweakletManager;
import org.netxms.ui.eclipse.console.api.ConsoleLoginListener;
import org.netxms.ui.eclipse.console.api.SessionProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LoginJob
implements IRunnableWithProgress {
    private Display display;
    private String server;
    private String loginName;
    private String password;
    private boolean encryptSession;

    public LoginJob(Display display, String server, String loginName, String password, boolean encryptSession) {
        this.display = display;
        this.server = server;
        this.loginName = loginName;
        this.password = password;
        this.encryptSession = encryptSession;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.setTaskName(Messages.LoginJob_connecting);
        try {
            try {
                String hostName;
                int port = 4701;
                String[] split = this.server.split(":");
                if (split.length == 2) {
                    hostName = split[0];
                    try {
                        port = Integer.valueOf(split[1]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    hostName = this.server;
                }
                NXCSession session = this.createSession(hostName, port);
                session.setConnClientInfo("nxmc/1.2.8");
                monitor.worked(1);
                session.connect();
                monitor.worked(1);
                monitor.setTaskName(Messages.LoginJob_sync_objects);
                session.syncObjects();
                monitor.worked(1);
                monitor.setTaskName(Messages.LoginJob_sync_users);
                session.syncUserDatabase();
                monitor.worked(1);
                monitor.setTaskName(Messages.LoginJob_sync_event_db);
                session.syncEventTemplates();
                monitor.worked(1);
                monitor.setTaskName(Messages.LoginJob_subscribe);
                session.subscribe(13);
                monitor.worked(1);
                ConsoleSharedData.setSession((Session)session);
                monitor.setTaskName(Messages.LoginJob_init_extensions);
                TweakletManager.postLogin(session);
                this.callLoginListeners(session);
                monitor.worked(1);
                KeepAliveHelper keepAliveTimer = new KeepAliveHelper();
                Thread thread = new Thread(keepAliveTimer);
                thread.setDaemon(true);
                thread.start();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.setTaskName("");
        }
    }

    private NXCSession createSession(String hostName, int port) {
        IConfigurationElement currentElement = null;
        int currentPriotity = 65536;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.sessionproviders");
        int i = 0;
        while (i < elements.length) {
            int priority = 65535;
            String value = elements[i].getAttribute("priority");
            if (value != null) {
                try {
                    priority = Integer.parseInt(value);
                    if (priority < 0 || priority > 65535) {
                        priority = 65535;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (priority < currentPriotity) {
                currentElement = elements[i];
                currentPriotity = priority;
            }
            ++i;
        }
        if (currentElement != null) {
            try {
                SessionProvider p = (SessionProvider)currentElement.createExecutableExtension("class");
                return p.createSession(hostName, port, this.loginName, this.password, this.encryptSession);
            }
            catch (CoreException coreException) {}
        }
        return new NXCSession(hostName, port, this.loginName, this.password, this.encryptSession);
    }

    private void callLoginListeners(NXCSession session) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.loginlisteners");
        int i = 0;
        while (i < elements.length) {
            try {
                ConsoleLoginListener listener = (ConsoleLoginListener)elements[i].createExecutableExtension("class");
                listener.afterLogin(session, this.display);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private final class KeepAliveHelper
    implements Runnable {
        private KeepAliveHelper() {
        }

        @Override
        public void run() {
            Session session = ConsoleSharedData.getSession();
            try {
                session.checkConnection();
                Thread.sleep(30000L);
            }
            catch (Exception exception) {}
        }
    }
}

