/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.BrandingManager;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class NXMCActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction actionExit;
    private ActionFactory.IWorkbenchAction actionAbout;
    private Action actionAboutCustom;
    private ActionFactory.IWorkbenchAction actionShowPreferences;
    private ActionFactory.IWorkbenchAction actionCustomizePerspective;
    private ActionFactory.IWorkbenchAction actionSavePerspective;
    private ActionFactory.IWorkbenchAction actionResetPerspective;
    private ActionFactory.IWorkbenchAction actionClosePerspective;
    private ActionFactory.IWorkbenchAction actionCloseAllPerspectives;
    private ActionFactory.IWorkbenchAction actionMinimize;
    private ActionFactory.IWorkbenchAction actionMaximize;
    private ActionFactory.IWorkbenchAction actionPrevView;
    private ActionFactory.IWorkbenchAction actionNextView;
    private ActionFactory.IWorkbenchAction actionQuickAccess;
    private ActionFactory.IWorkbenchAction actionShowViewMenu;
    private Action actionOpenProgressView;
    private Action actionFullScreen;
    private Action actionLangChinese;
    private Action actionLangEnglish;
    private Action actionLangRussian;
    private Action actionLangSpanish;
    private IContributionItem contribItemShowView;
    private IContributionItem contribItemOpenPerspective;

    public NXMCActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        this.contribItemShowView = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        this.contribItemOpenPerspective = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        this.actionExit = ActionFactory.QUIT.create(window);
        this.register((IAction)this.actionExit);
        this.actionAbout = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.actionAbout);
        this.actionAboutCustom = new Action(Messages.NXMCActionBarAdvisor_About){

            public void run() {
                Dialog dlg = BrandingManager.getInstance().getAboutDialog(window.getShell());
                if (dlg != null) {
                    dlg.open();
                } else {
                    MessageDialogHelper.openInformation(window.getShell(), Messages.NXMCActionBarAdvisor_AboutTitle, String.format(Messages.NXMCActionBarAdvisor_AboutText, "1.2.8"));
                }
            }
        };
        this.actionShowPreferences = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.actionShowPreferences);
        this.actionCustomizePerspective = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.actionCustomizePerspective);
        this.actionSavePerspective = ActionFactory.SAVE_PERSPECTIVE.create(window);
        this.register((IAction)this.actionSavePerspective);
        this.actionResetPerspective = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register((IAction)this.actionResetPerspective);
        this.actionClosePerspective = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register((IAction)this.actionClosePerspective);
        this.actionCloseAllPerspectives = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register((IAction)this.actionCloseAllPerspectives);
        this.actionMinimize = ActionFactory.MINIMIZE.create(window);
        this.register((IAction)this.actionMinimize);
        this.actionMaximize = ActionFactory.MAXIMIZE.create(window);
        this.register((IAction)this.actionMaximize);
        this.actionPrevView = ActionFactory.PREVIOUS_PART.create(window);
        this.register((IAction)this.actionPrevView);
        this.actionNextView = ActionFactory.NEXT_PART.create(window);
        this.register((IAction)this.actionNextView);
        this.actionQuickAccess = ActionFactory.SHOW_QUICK_ACCESS.create(window);
        this.register((IAction)this.actionQuickAccess);
        this.actionShowViewMenu = ActionFactory.SHOW_VIEW_MENU.create(window);
        this.register((IAction)this.actionShowViewMenu);
        this.actionOpenProgressView = new Action(){

            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow win;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (win = wb.getActiveWorkbenchWindow()) != null && (page = win.getActivePage()) != null) {
                    try {
                        page.showView("org.eclipse.ui.views.ProgressView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.actionOpenProgressView.setText(Messages.NXMCActionBarAdvisor_progress);
        this.actionOpenProgressView.setImageDescriptor(Activator.getImageDescriptor("icons/pview.gif"));
        this.actionFullScreen = new Action(Messages.NXMCActionBarAdvisor_FullScreen, 2){

            public void run() {
                boolean fullScreen = !PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getFullScreen();
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setFullScreen(fullScreen);
                NXMCActionBarAdvisor.this.actionFullScreen.setChecked(fullScreen);
            }
        };
        this.actionFullScreen.setChecked(false);
        this.actionFullScreen.setId("org.netxms.ui.eclipse.console.actions.full_screen");
        this.actionFullScreen.setActionDefinitionId("org.netxms.ui.eclipse.console.commands.full_screen");
        this.getActionBarConfigurer().registerGlobalAction((IAction)this.actionFullScreen);
        this.actionLangChinese = new Action(Messages.NXMCActionBarAdvisor_LangChinese, Activator.getImageDescriptor("icons/lang/zh.png")){

            public void run() {
                NXMCActionBarAdvisor.this.setLanguage("zh");
            }
        };
        this.actionLangEnglish = new Action(Messages.NXMCActionBarAdvisor_LangEnglish, Activator.getImageDescriptor("icons/lang/gb.png")){

            public void run() {
                NXMCActionBarAdvisor.this.setLanguage("en");
            }
        };
        this.actionLangRussian = new Action(Messages.NXMCActionBarAdvisor_LangRussian, Activator.getImageDescriptor("icons/lang/ru.png")){

            public void run() {
                NXMCActionBarAdvisor.this.setLanguage("ru");
            }
        };
        this.actionLangSpanish = new Action(Messages.NXMCActionBarAdvisor_LangSpanish, Activator.getImageDescriptor("icons/lang/es.png")){

            public void run() {
                NXMCActionBarAdvisor.this.setLanguage("es");
            }
        };
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager(Messages.NXMCActionBarAdvisor_menu_file, "file");
        MenuManager viewMenu = new MenuManager(Messages.NXMCActionBarAdvisor_menu_view, "view");
        MenuManager monitorMenu = new MenuManager(Messages.NXMCActionBarAdvisor_menu_monitor, "monitor");
        MenuManager configMenu = new MenuManager(Messages.NXMCActionBarAdvisor_menu_configuration, "config");
        MenuManager toolsMenu = new MenuManager(Messages.NXMCActionBarAdvisor_menu_tools, "tools");
        MenuManager windowMenu = new MenuManager(Messages.NXMCActionBarAdvisor_Window, "window");
        MenuManager helpMenu = new MenuManager(Messages.NXMCActionBarAdvisor_menu_help, "help");
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)viewMenu);
        menuBar.add((IContributionItem)monitorMenu);
        menuBar.add((IContributionItem)configMenu);
        menuBar.add((IContributionItem)toolsMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        if (!Activator.getDefault().getPreferenceStore().getBoolean("HIDE_WINDOW_MENU")) {
            menuBar.add((IContributionItem)windowMenu);
        }
        menuBar.add((IContributionItem)helpMenu);
        MenuManager langMenu = new MenuManager(Messages.NXMCActionBarAdvisor_Language);
        langMenu.add((IAction)this.actionLangChinese);
        langMenu.add((IAction)this.actionLangEnglish);
        langMenu.add((IAction)this.actionLangRussian);
        langMenu.add((IAction)this.actionLangSpanish);
        fileMenu.add((IAction)this.actionShowPreferences);
        fileMenu.add((IContributionItem)langMenu);
        fileMenu.add((IContributionItem)new GroupMarker("additions"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.actionExit);
        viewMenu.add((IContributionItem)new GroupMarker("product"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IContributionItem)new GroupMarker("primary"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IContributionItem)new GroupMarker("logs"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.actionOpenProgressView);
        viewMenu.add((IContributionItem)new GroupMarker("tools"));
        monitorMenu.add((IContributionItem)new GroupMarker("additions"));
        toolsMenu.add((IContributionItem)new GroupMarker("additions"));
        windowMenu.add((IAction)this.actionFullScreen);
        windowMenu.add((IContributionItem)new Separator());
        MenuManager openPerspectiveMenuMgr = new MenuManager(Messages.NXMCActionBarAdvisor_OpenPerspective, "openPerspective");
        openPerspectiveMenuMgr.add(this.contribItemOpenPerspective);
        windowMenu.add((IContributionItem)openPerspectiveMenuMgr);
        MenuManager showViewMenuMgr = new MenuManager(Messages.NXMCActionBarAdvisor_ShowView, "showView");
        showViewMenuMgr.add(this.contribItemShowView);
        windowMenu.add((IContributionItem)showViewMenuMgr);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.actionCustomizePerspective);
        windowMenu.add((IAction)this.actionSavePerspective);
        windowMenu.add((IAction)this.actionResetPerspective);
        windowMenu.add((IAction)this.actionClosePerspective);
        windowMenu.add((IAction)this.actionCloseAllPerspectives);
        windowMenu.add((IContributionItem)new Separator());
        MenuManager navMenu = new MenuManager(Messages.NXMCActionBarAdvisor_Navigation, "navigate");
        windowMenu.add((IContributionItem)navMenu);
        navMenu.add((IAction)this.actionQuickAccess);
        navMenu.add((IAction)this.actionShowViewMenu);
        navMenu.add((IContributionItem)new Separator());
        navMenu.add((IAction)this.actionMaximize);
        navMenu.add((IAction)this.actionMinimize);
        navMenu.add((IContributionItem)new Separator());
        navMenu.add((IAction)this.actionNextView);
        navMenu.add((IAction)this.actionPrevView);
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
        helpMenu.add((IAction)(BrandingManager.getInstance().getAboutDialog(null) != null ? this.actionAboutCustom : this.actionAbout));
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "product"));
        toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "view"));
        toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "logs"));
        toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "tools"));
        toolbar = new ToolBarManager(0x820000);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "config"));
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        StatusLineContributionItem statusItem = new StatusLineContributionItem("ConnectionStatus");
        statusItem.setText("");
        statusLine.add((IContributionItem)statusItem);
        Activator.getDefault().setStatusItemConnection(statusItem);
    }

    private void setLanguage(String locale) {
        block24: {
            if (!MessageDialogHelper.openConfirm(null, Messages.NXMCActionBarAdvisor_ConfirmRestart, Messages.NXMCActionBarAdvisor_RestartConsoleMessage)) {
                return;
            }
            Activator.getDefault().getPreferenceStore().setValue("NL", locale);
            Location configArea = Platform.getInstallLocation();
            if (configArea != null) {
                BufferedReader in = null;
                BufferedWriter out = null;
                try {
                    try {
                        String line;
                        URL iniFileUrl = new URL(String.valueOf(configArea.getURL().toExternalForm()) + "nxmc.ini");
                        String iniFileName = iniFileUrl.getFile();
                        File iniFile = new File(iniFileName);
                        File iniFileBackup = new File(String.valueOf(iniFileName) + ".bak");
                        iniFileBackup.delete();
                        iniFile.renameTo(iniFileBackup);
                        in = new BufferedReader(new FileReader(String.valueOf(iniFileName) + ".bak"));
                        out = new BufferedWriter(new FileWriter(iniFileName));
                        int state = 0;
                        while ((line = in.readLine()) != null) {
                            switch (state) {
                                case 0: {
                                    if (!line.equals("-nl")) break;
                                    state = 1;
                                    break;
                                }
                                case 1: {
                                    line = locale;
                                    state = 0;
                                }
                            }
                            out.write(line);
                            out.newLine();
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.netxms.ui.eclipse.console", 0, "Exception in setLanguage()", (Throwable)e));
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                            break block24;
                        }
                        catch (IOException iOException) {}
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        System.getProperties().setProperty("eclipse.exitdata", "-nl " + locale);
        PlatformUI.getWorkbench().restart();
    }
}

