/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.netxms.api.client.Session;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.LoginJob;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.NXMCActionBarAdvisor;
import org.netxms.ui.eclipse.console.SplashHandler;
import org.netxms.ui.eclipse.console.TweakletManager;
import org.netxms.ui.eclipse.console.dialogs.LoginDialog;
import org.netxms.ui.eclipse.console.dialogs.PasswordExpiredDialog;
import org.netxms.ui.eclipse.console.tools.RegionalSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class NXMCWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public NXMCWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new NXMCActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        this.doLogin(Display.getCurrent());
        RegionalSettings.updateFromPreferences();
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(ps.getBoolean("SHOW_COOLBAR"));
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowPerspectiveBar(true);
        TweakletManager.preWindowOpen(configurer);
    }

    public void postWindowCreate() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        Session session = ConsoleSharedData.getSession();
        Activator.getDefault().getStatusItemConnection().setText(String.valueOf(session.getUserName()) + "@" + session.getServerAddress() + " (" + session.getServerVersion() + ")");
        if (Activator.getDefault().getPreferenceStore().getBoolean("SHOW_TRAY_ICON")) {
            Activator.showTrayIcon();
        }
        TweakletManager.postWindowCreate(configurer);
    }

    private void doLogin(Display display) {
        PasswordExpiredDialog dlg;
        Session session;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        boolean success = false;
        boolean autoConnect = false;
        String password = "";
        String[] stringArray = Platform.getCommandLineArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-server=")) {
                settings.put("Connect.Server", s.substring(8));
            } else if (s.startsWith("-login=")) {
                settings.put("Connect.Login", s.substring(7));
            } else if (s.startsWith("-password=")) {
                password = s.substring(10);
            } else if (s.equals("-auto")) {
                autoConnect = true;
            }
            ++n2;
        }
        do {
            if (!autoConnect) {
                LoginDialog loginDialog = new LoginDialog(null);
                if (loginDialog.open() != 0) {
                    System.exit(0);
                }
                password = loginDialog.getPassword();
            } else {
                autoConnect = false;
            }
            try {
                LoginJob job = new LoginJob(display, settings.get("Connect.Server"), settings.get("Connect.Login"), password, settings.getBoolean("Connect.Encrypt"));
                ModalContext.run((IRunnableWithProgress)job, (boolean)true, (IProgressMonitor)SplashHandler.getInstance().getBundleProgressMonitor(), (Display)Display.getCurrent());
                success = true;
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
                MessageDialog.openError(null, (String)Messages.NXMCWorkbenchWindowAdvisor_connectionError, (String)e.getCause().getLocalizedMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openError(null, (String)Messages.NXMCWorkbenchWindowAdvisor_exception, (String)e.toString());
            }
        } while (!success);
        if (success && (session = ConsoleSharedData.getSession()).isPasswordExpired() && (dlg = new PasswordExpiredDialog(null)).open() == 0) {
            final String currentPassword = password;
            IRunnableWithProgress job = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.setTaskName(Messages.NXMCWorkbenchWindowAdvisor_ChangingPassword);
                            ((UserManager)session).setUserPassword((long)session.getUserId(), dlg.getPassword(), currentPassword);
                            monitor.setTaskName("");
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                ModalContext.run((IRunnableWithProgress)job, (boolean)true, (IProgressMonitor)SplashHandler.getInstance().getBundleProgressMonitor(), (Display)Display.getCurrent());
                MessageDialog.openInformation(null, (String)Messages.NXMCWorkbenchWindowAdvisor_title_information, (String)Messages.NXMCWorkbenchWindowAdvisor_passwd_changed);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError(null, (String)Messages.NXMCWorkbenchWindowAdvisor_title_error, (String)(String.valueOf(Messages.NXMCWorkbenchWindowAdvisor_cannot_change_passwd) + " " + e.getCause().getLocalizedMessage()));
            }
            catch (InterruptedException e) {
                MessageDialog.openError(null, (String)Messages.NXMCWorkbenchWindowAdvisor_exception, (String)e.toString());
            }
        }
    }
}

