/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.preferencepages;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class HttpProxyPrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button checkUseProxy;
    private LabeledText editProxyServer;
    private LabeledText editProxyPort;
    private LabeledText editExclusions;
    private Button checkRequireAuth;
    private LabeledText editLogin;
    private LabeledText editPassword;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.checkUseProxy = new Button(dialogArea, 32);
        this.checkUseProxy.setText(Messages.HttpProxyPrefs_UserProxyMessage);
        this.checkUseProxy.setSelection(this.getPreferenceStore().getBoolean("HTTP_PROXY_ENABLED"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkUseProxy.setLayoutData((Object)gd);
        this.checkUseProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = HttpProxyPrefs.this.checkUseProxy.getSelection();
                HttpProxyPrefs.this.editProxyServer.setEnabled(enabled);
                HttpProxyPrefs.this.editProxyPort.setEnabled(enabled);
                HttpProxyPrefs.this.editExclusions.setEnabled(enabled);
                HttpProxyPrefs.this.checkRequireAuth.setEnabled(enabled);
                HttpProxyPrefs.this.editLogin.setEnabled(enabled && HttpProxyPrefs.this.checkRequireAuth.getEnabled());
                HttpProxyPrefs.this.editPassword.setEnabled(enabled && HttpProxyPrefs.this.checkRequireAuth.getEnabled());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.editProxyServer = new LabeledText(dialogArea, 0);
        this.editProxyServer.setLabel(Messages.HttpProxyPrefs_ProxyServer);
        this.editProxyServer.setText(this.getPreferenceStore().getString("HTTP_PROXY_SERVER"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.editProxyServer.setLayoutData(gd);
        this.editProxyPort = new LabeledText(dialogArea, 0);
        this.editProxyPort.setLabel(Messages.HttpProxyPrefs_Port);
        this.editProxyPort.setText(this.getPreferenceStore().getString("HTTP_PROXY_PORT"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 100;
        this.editProxyPort.setLayoutData(gd);
        this.editExclusions = new LabeledText(dialogArea, 0);
        this.editExclusions.setLabel(Messages.HttpProxyPrefs_ExcludedAddresses);
        this.editExclusions.setText(this.getPreferenceStore().getString("HTTP_PROXY_EXCLUSIONS").replaceAll("\\|", ","));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.editExclusions.setLayoutData(gd);
        this.editProxyServer.setEnabled(this.checkUseProxy.getSelection());
        this.editProxyPort.setEnabled(this.checkUseProxy.getSelection());
        this.editExclusions.setEnabled(this.checkUseProxy.getSelection());
        this.checkRequireAuth = new Button(dialogArea, 32);
        this.checkRequireAuth.setText(Messages.HttpProxyPrefs_ProxyRequireAuth);
        this.checkRequireAuth.setSelection(this.getPreferenceStore().getBoolean("HTTP_PROXY_AUTH"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        this.checkRequireAuth.setLayoutData((Object)gd);
        this.checkRequireAuth.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = HttpProxyPrefs.this.checkUseProxy.getSelection() && HttpProxyPrefs.this.checkRequireAuth.getSelection();
                HttpProxyPrefs.this.editLogin.setEnabled(enabled);
                HttpProxyPrefs.this.editPassword.setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.editLogin = new LabeledText(dialogArea, 0);
        this.editLogin.setLabel(Messages.HttpProxyPrefs_Login);
        this.editLogin.setText(this.getPreferenceStore().getString("HTTP_PROXY_LOGIN"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.editLogin.setLayoutData(gd);
        this.editPassword = new LabeledText(dialogArea, 0, 0x400800);
        this.editPassword.setLabel(Messages.HttpProxyPrefs_Password);
        this.editPassword.setText(this.getPreferenceStore().getString("HTTP_PROXY_PASSWORD"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.editPassword.setLayoutData(gd);
        boolean enabled = this.checkUseProxy.getSelection() && this.checkRequireAuth.getSelection();
        this.editLogin.setEnabled(enabled);
        this.editPassword.setEnabled(enabled);
        return dialogArea;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkUseProxy.setSelection(this.getPreferenceStore().getDefaultBoolean("HTTP_PROXY_ENABLED"));
        this.editProxyServer.setText(this.getPreferenceStore().getDefaultString("HTTP_PROXY_SERVER"));
        this.editProxyPort.setText(this.getPreferenceStore().getDefaultString("HTTP_PROXY_PORT"));
        this.editExclusions.setText(this.getPreferenceStore().getDefaultString("HTTP_PROXY_EXCLUSIONS").replaceAll("\\|", ","));
        this.checkRequireAuth.setSelection(this.getPreferenceStore().getDefaultBoolean("HTTP_PROXY_AUTH"));
        this.editLogin.setText(this.getPreferenceStore().getDefaultString("HTTP_PROXY_LOGIN"));
        this.editPassword.setText(this.getPreferenceStore().getDefaultString("HTTP_PROXY_PASSWORD"));
        this.editProxyServer.setEnabled(this.checkUseProxy.getSelection());
        this.editProxyPort.setEnabled(this.checkUseProxy.getSelection());
        this.editExclusions.setEnabled(this.checkUseProxy.getSelection());
        this.checkRequireAuth.setEnabled(this.checkUseProxy.getSelection());
        this.editLogin.setEnabled(this.checkUseProxy.getSelection() && this.checkRequireAuth.getSelection());
        this.editPassword.setEnabled(this.checkUseProxy.getSelection() && this.checkRequireAuth.getSelection());
    }

    public boolean performOk() {
        final IPreferenceStore ps = this.getPreferenceStore();
        ps.setValue("HTTP_PROXY_ENABLED", this.checkUseProxy.getSelection());
        ps.setValue("HTTP_PROXY_SERVER", this.editProxyServer.getText());
        ps.setValue("HTTP_PROXY_PORT", this.editProxyPort.getText());
        ps.setValue("HTTP_PROXY_EXCLUSIONS", this.editExclusions.getText().replaceAll("\\,", "|"));
        ps.setValue("HTTP_PROXY_AUTH", this.checkRequireAuth.getSelection());
        ps.setValue("HTTP_PROXY_LOGIN", this.editLogin.getText());
        ps.setValue("HTTP_PROXY_PASSWORD", this.editPassword.getText());
        if (this.checkUseProxy.getSelection()) {
            System.setProperty("http.proxyHost", ps.getString("HTTP_PROXY_SERVER"));
            System.setProperty("http.proxyPort", ps.getString("HTTP_PROXY_PORT"));
            System.setProperty("http.noProxyHosts", ps.getString("HTTP_PROXY_EXCLUSIONS"));
            if (this.checkRequireAuth.getSelection()) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(ps.getString("HTTP_PROXY_LOGIN"), ps.getString("HTTP_PROXY_PASSWORD").toCharArray());
                    }
                });
            } else {
                Authenticator.setDefault(null);
            }
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("http.noProxyHosts");
            Authenticator.setDefault(null);
        }
        return super.performOk();
    }
}

