/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.preferencepages;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.netxms.api.client.Session;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.tools.RegionalSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class RegionalSettingsPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo dateTimeFormat;
    private LabeledText dateFormatString;
    private LabeledText timeFormatString;
    private LabeledText dateTimeExample;
    private int format;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.dateTimeFormat = WidgetHelper.createLabeledCombo(dialogArea, 2056, Messages.RegionalSettingsPrefPage_DateTimeFormat, gd);
        this.dateTimeFormat.add(Messages.RegionalSettingsPrefPage_FmtServer);
        this.dateTimeFormat.add(Messages.RegionalSettingsPrefPage_FmtJava);
        this.dateTimeFormat.add(Messages.RegionalSettingsPrefPage_FmtCustom);
        this.format = this.getPreferenceStore().getInt("DATETIME_FORMAT");
        this.dateTimeFormat.select(this.format);
        this.dateTimeFormat.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RegionalSettingsPrefPage.this.format = RegionalSettingsPrefPage.this.dateTimeFormat.getSelectionIndex();
                RegionalSettingsPrefPage.this.dateFormatString.setEnabled(RegionalSettingsPrefPage.this.format == 2);
                RegionalSettingsPrefPage.this.timeFormatString.setEnabled(RegionalSettingsPrefPage.this.format == 2);
                RegionalSettingsPrefPage.this.updateExample(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegionalSettingsPrefPage.this.updateExample((Control)e.widget);
            }
        };
        this.dateFormatString = new LabeledText(dialogArea, 0);
        this.dateFormatString.setLabel(Messages.RegionalSettingsPrefPage_DateFormatString);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dateFormatString.setLayoutData(gd);
        this.dateFormatString.setText(this.getPreferenceStore().getString("DATE_FORMAT_STRING"));
        this.dateFormatString.setEnabled(this.format == 2);
        this.dateFormatString.getTextControl().addModifyListener(listener);
        this.timeFormatString = new LabeledText(dialogArea, 0);
        this.timeFormatString.setLabel(Messages.RegionalSettingsPrefPage_TimeFormatString);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.timeFormatString.setLayoutData(gd);
        this.timeFormatString.setText(this.getPreferenceStore().getString("TIME_FORMAT_STRING"));
        this.timeFormatString.setEnabled(this.format == 2);
        this.timeFormatString.getTextControl().addModifyListener(listener);
        this.dateTimeExample = new LabeledText(dialogArea, 0, 2056);
        this.dateTimeExample.setLabel(Messages.RegionalSettingsPrefPage_Example);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.dateTimeExample.setLayoutData(gd);
        this.updateExample(null);
        return dialogArea;
    }

    private void updateExample(Control updatedControl) {
        DateFormat df;
        switch (this.format) {
            case 0: {
                Session session = ConsoleSharedData.getSession();
                df = new SimpleDateFormat(String.valueOf(session.getDateFormat()) + " " + session.getTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(String.valueOf(this.dateFormatString.getText()) + " " + this.timeFormatString.getText());
                    break;
                }
                catch (IllegalArgumentException e) {
                    this.setErrorMessage(e.getLocalizedMessage());
                    if (updatedControl != null) {
                        updatedControl.setBackground(SharedColors.getColor("ErrorBackground", this.getShell().getDisplay()));
                    }
                    return;
                }
            }
            default: {
                df = DateFormat.getDateTimeInstance(3, 2);
            }
        }
        this.dateTimeExample.setText(df.format(new Date(System.currentTimeMillis())));
        this.setErrorMessage(null);
        this.dateFormatString.getTextControl().setBackground(null);
        this.timeFormatString.getTextControl().setBackground(null);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.format = this.getPreferenceStore().getInt("DATETIME_FORMAT");
        this.dateTimeFormat.select(this.format);
        this.dateFormatString.setText(this.getPreferenceStore().getString("DATE_FORMAT_STRING"));
        this.timeFormatString.setText(this.getPreferenceStore().getString("TIME_FORMAT_STRING"));
        this.dateFormatString.setEnabled(this.format == 2);
        this.timeFormatString.setEnabled(this.format == 2);
        this.updateExample(null);
    }

    public boolean performOk() {
        IPreferenceStore ps = this.getPreferenceStore();
        ps.setValue("DATETIME_FORMAT", this.format);
        ps.setValue("DATE_FORMAT_STRING", this.dateFormatString.getText());
        ps.setValue("TIME_FORMAT_STRING", this.timeFormatString.getText());
        RegionalSettings.updateFromPreferences();
        return true;
    }
}

