/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.resources;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedColors;

public final class StatusDisplayInfo {
    private static String[] statusText = new String[9];
    private static ImageDescriptor[] statusImageDesc = new ImageDescriptor[9];
    private static Image[] statusImage = new Image[9];
    private static String[] statusColor = new String[9];

    public static void init(Display display) {
        StatusDisplayInfo.statusText[0] = Messages.StatusDisplayInfo_Normal;
        StatusDisplayInfo.statusText[1] = Messages.StatusDisplayInfo_Warning;
        StatusDisplayInfo.statusText[2] = Messages.StatusDisplayInfo_Minor;
        StatusDisplayInfo.statusText[3] = Messages.StatusDisplayInfo_Major;
        StatusDisplayInfo.statusText[4] = Messages.StatusDisplayInfo_Critical;
        StatusDisplayInfo.statusText[5] = Messages.StatusDisplayInfo_Unknown;
        StatusDisplayInfo.statusText[6] = Messages.StatusDisplayInfo_Unmanaged;
        StatusDisplayInfo.statusText[7] = Messages.StatusDisplayInfo_Disabled;
        StatusDisplayInfo.statusText[8] = Messages.StatusDisplayInfo_Testing;
        StatusDisplayInfo.statusImageDesc[0] = Activator.getImageDescriptor("icons/status/normal.png");
        StatusDisplayInfo.statusImageDesc[1] = Activator.getImageDescriptor("icons/status/warning.png");
        StatusDisplayInfo.statusImageDesc[2] = Activator.getImageDescriptor("icons/status/minor.png");
        StatusDisplayInfo.statusImageDesc[3] = Activator.getImageDescriptor("icons/status/major.png");
        StatusDisplayInfo.statusImageDesc[4] = Activator.getImageDescriptor("icons/status/critical.png");
        StatusDisplayInfo.statusImageDesc[5] = Activator.getImageDescriptor("icons/status/unknown.png");
        StatusDisplayInfo.statusImageDesc[6] = Activator.getImageDescriptor("icons/status/unmanaged.png");
        StatusDisplayInfo.statusImageDesc[7] = Activator.getImageDescriptor("icons/status/disabled.png");
        StatusDisplayInfo.statusImageDesc[8] = Activator.getImageDescriptor("icons/status/testing.png");
        int i = 0;
        while (i < statusImageDesc.length) {
            StatusDisplayInfo.statusImage[i] = statusImageDesc[i].createImage();
            ++i;
        }
        StatusDisplayInfo.statusColor[0] = "Status.Normal";
        StatusDisplayInfo.statusColor[1] = "Status.Warning";
        StatusDisplayInfo.statusColor[2] = "Status.Minor";
        StatusDisplayInfo.statusColor[3] = "Status.Major";
        StatusDisplayInfo.statusColor[4] = "Status.Critical";
        StatusDisplayInfo.statusColor[5] = "Status.Unknown";
        StatusDisplayInfo.statusColor[6] = "Status.Unmanaged";
        StatusDisplayInfo.statusColor[7] = "Status.Disabled";
        StatusDisplayInfo.statusColor[8] = "Status.Testing";
    }

    public static String getStatusText(int severity) {
        try {
            return statusText[severity];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "<unknown>";
        }
    }

    public static ImageDescriptor getStatusImageDescriptor(int severity) {
        try {
            return statusImageDesc[severity];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static Image getStatusImage(int severity) {
        try {
            return statusImage[severity];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static Color getStatusColor(int severity) {
        try {
            return SharedColors.getColor(statusColor[severity], Display.getCurrent());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }
}

